/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.prelude.templates.SearchRendererAdaptor;
import com.yahoo.prelude.templates.TemplateSet;
import com.yahoo.prelude.templates.UserTemplate;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.search.Result;
import java.util.Map;

public class Templating {
    private final Result result;
    private Renderer<Result> renderer;

    public Templating(Result result) {
        this.result = result;
    }

    public int getFirstHitNo() {
        return this.result.getQuery().getOffset() + 1;
    }

    public long getNextFirstHitNo() {
        if (this.result.getQuery().getHits() > this.result.getConcreteHitCount()) {
            return 0L;
        }
        return Math.min((long)(this.getLastHitNo() + 1), this.result.getTotalHitCount());
    }

    public long getNextLastHitNo() {
        if (this.result.getQuery().getHits() > this.result.getConcreteHitCount()) {
            return 0L;
        }
        return Math.min((long)(this.getLastHitNo() + this.result.getConcreteHitCount()), this.result.getTotalHitCount());
    }

    public int getLastHitNo() {
        return this.getFirstHitNo() + this.result.getConcreteHitCount() - 1;
    }

    public int getPrevFirstHitNo() {
        return Math.max(this.getFirstHitNo() - this.result.getQuery().getHits(), 1);
    }

    public int getPrevLastHitNo() {
        return Math.max(this.getFirstHitNo() - 1, 0);
    }

    public String getNextResultURL() {
        HttpRequest request = this.result.getQuery().getHttpRequest();
        StringBuilder nextURL = new StringBuilder();
        nextURL.append(this.getPath(request)).append("?");
        this.parametersExceptOffset(request, nextURL);
        int offset = this.getLastHitNo();
        nextURL.append("&").append("offset=").append(Integer.toString(offset));
        return nextURL.toString();
    }

    public String getPreviousResultURL() {
        HttpRequest request = this.result.getQuery().getHttpRequest();
        StringBuilder prevURL = new StringBuilder();
        prevURL.append(this.getPath(request)).append("?");
        this.parametersExceptOffset(request, prevURL);
        int offset = this.getPrevFirstHitNo() - 1;
        prevURL.append("&").append("offset=").append(Integer.toString(offset));
        return prevURL.toString();
    }

    public String getCurrentResultURL() {
        HttpRequest request = this.result.getQuery().getHttpRequest();
        StringBuilder thisURL = new StringBuilder();
        thisURL.append(this.getPath(request)).append("?");
        this.parameters(request, thisURL);
        return thisURL.toString();
    }

    private String getPath(HttpRequest request) {
        String path = request.getUri().getPath();
        if (path == null) {
            path = "";
        }
        return path;
    }

    private void parametersExceptOffset(HttpRequest request, StringBuilder nextURL) {
        int startLength = nextURL.length();
        for (Map.Entry property : request.propertyMap().entrySet()) {
            if (((String)property.getKey()).equals("offset")) continue;
            if (nextURL.length() > startLength) {
                nextURL.append("&");
            }
            nextURL.append((String)property.getKey()).append("=").append((String)property.getValue());
        }
    }

    private void parameters(HttpRequest request, StringBuilder nextURL) {
        int startLength = nextURL.length();
        for (Map.Entry property : request.propertyMap().entrySet()) {
            if (nextURL.length() > startLength) {
                nextURL.append("&");
            }
            nextURL.append((String)property.getKey()).append("=").append((String)property.getValue());
        }
    }

    public UserTemplate getTemplates() {
        if (this.renderer == null) {
            return TemplateSet.getDefault();
        }
        if (this.renderer instanceof SearchRendererAdaptor) {
            return ((SearchRendererAdaptor)this.renderer).getAdaptee();
        }
        throw new RuntimeException("Please use getTemplate() instead of getTemplates() when using the new template api.");
    }

    public void setTemplates(UserTemplate templates) {
        if (templates == null) {
            this.setTemplates(TemplateSet.getDefault());
        } else {
            this.setRenderer(new SearchRendererAdaptor(templates));
        }
    }

    @Deprecated
    public Renderer<Result> getRenderer() {
        return this.renderer;
    }

    @Deprecated
    public void setRenderer(Renderer<Result> renderer) {
        this.renderer = renderer;
    }

    public boolean usesDefaultTemplate() {
        return this.renderer == null || this.renderer instanceof SearchRendererAdaptor && ((SearchRendererAdaptor)this.renderer).getAdaptee().isDefaultTemplateSet();
    }
}

