/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.collections.ListenableArrayList;
import com.yahoo.net.URI;
import com.yahoo.processing.response.AbstractDataList;
import com.yahoo.processing.response.DataList;
import com.yahoo.processing.response.DefaultIncomingData;
import com.yahoo.processing.response.IncomingData;
import com.yahoo.search.result.DeepHitIterator;
import com.yahoo.search.result.DefaultErrorHit;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitIterator;
import com.yahoo.search.result.HitOrderer;
import com.yahoo.search.result.Relevance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HitGroup
extends Hit
implements DataList<Hit>,
Cloneable,
Iterable<Hit> {
    private ListenableArrayList<Hit> hits = new ListenableArrayList(16);
    private transient List<Hit> unmodifiableHits = Collections.unmodifiableList(this.hits);
    private boolean hitsSorted = true;
    private boolean deletionBreaksOrdering = false;
    private boolean orderedHits = false;
    private int concreteHitCount = 0;
    private transient HitOrderer hitOrderer = null;
    private int subgroupCount = 0;
    private int notCachedCount = 0;
    private DefaultErrorHit errorHit = null;
    private final ListenableFuture<DataList<Hit>> completedFuture;
    private final IncomingData<Hit> incomingHits;

    public HitGroup() {
        this.incomingHits = new IncomingData.NullIncomingData((DataList)this);
        this.setRelevance(new Relevance(1.0));
        this.setMeta(true);
        this.completedFuture = new IncomingData.NullIncomingData.ImmediateFuture((DataList)this);
    }

    public HitGroup(String id) {
        this(id, new Relevance(1.0));
    }

    public HitGroup(String id, double relevance) {
        this(id, new Relevance(relevance));
    }

    public HitGroup(String id, Relevance relevance) {
        super(id, relevance);
        this.incomingHits = new IncomingData.NullIncomingData((DataList)this);
        this.setMeta(true);
        this.completedFuture = new IncomingData.NullIncomingData.ImmediateFuture((DataList)this);
    }

    protected HitGroup(String id, Relevance relevance, IncomingData<Hit> incomingHits) {
        super(id, relevance);
        this.incomingHits = incomingHits;
        this.setMeta(true);
        this.completedFuture = new AbstractDataList.DrainOnGetFuture((DataList)this);
    }

    public static HitGroup createAsync(String id) {
        DefaultIncomingData incomingData = new DefaultIncomingData();
        HitGroup hitGroup = new HitGroup(id, new Relevance(1.0), (IncomingData<Hit>)incomingData);
        incomingData.assignOwner((DataList)hitGroup);
        return hitGroup;
    }

    @Override
    public void setId(String id) {
        this.setId(new URI(id));
    }

    @Override
    public void setId(URI id) {
        super.assignId(id);
    }

    public void setOrdered(boolean ordered) {
        this.orderedHits = ordered;
    }

    public int size() {
        return this.hits.size();
    }

    public int getConcreteSize() {
        if (this.subgroupCount < 1) {
            return this.concreteHitCount;
        }
        int recursiveConcreteCount = this.concreteHitCount;
        for (Hit hit : this.hits) {
            if (!(hit instanceof HitGroup)) continue;
            recursiveConcreteCount += ((HitGroup)hit).getConcreteSize();
        }
        return recursiveConcreteCount;
    }

    public int getConcreteSizeShallow() {
        return this.concreteHitCount;
    }

    public int getSubgroupCount() {
        return this.subgroupCount;
    }

    public Hit add(Hit hit) {
        if (hit.isMeta() && hit instanceof DefaultErrorHit) {
            if (this.errorHit != null) {
                this.errorHit.addErrors((DefaultErrorHit)hit);
                return this.errorHit;
            }
            this.errorHit = this.merge(this.consumeAnyQueryErrors(), (DefaultErrorHit)hit);
            hit = this.errorHit;
        }
        this.handleNewHit(hit);
        this.hits.add((Object)hit);
        return hit;
    }

    public void addAll(List<Hit> hits) {
        for (Hit hit : hits) {
            this.add(hit);
        }
    }

    public Hit get(int index) {
        this.updateHits();
        this.ensureSorted();
        return (Hit)this.hits.get(index);
    }

    public Hit get(String id) {
        return this.get(id, -1);
    }

    public Hit get(String id, int depth) {
        return this.get(new URI(id), depth);
    }

    public Hit get(URI id, int depth) {
        this.updateHits();
        Iterator<Hit> i = this.unorderedIterator();
        while (i.hasNext()) {
            Hit found;
            Hit hit = i.next();
            URI hitUri = hit.getId();
            if (hitUri != null && hitUri.equals((Object)id)) {
                return hit;
            }
            if (!(hit instanceof HitGroup) || depth == 0 || (found = ((HitGroup)hit).get(id, depth - 1)) == null) continue;
            return found;
        }
        return null;
    }

    public void set(int index, Hit hit) {
        this.updateHits();
        if (hit instanceof ErrorHit) {
            this.add(hit);
            return;
        }
        this.handleNewHit(hit);
        Hit oldHit = (Hit)this.hits.set(index, (Object)hit);
        if (oldHit != null) {
            this.handleRemovedHit(oldHit);
        }
    }

    public void add(int index, Hit hit) {
        if (hit instanceof ErrorHit) {
            this.add(hit);
            return;
        }
        boolean wasSorted = this.hitsSorted;
        this.handleNewHit(hit);
        this.hits.add(index, (Object)hit);
        this.hitsSorted = wasSorted;
    }

    public Hit remove(String uriString) {
        return this.remove(new URI(uriString));
    }

    public Hit remove(URI uri) {
        Iterator it = this.hits.iterator();
        while (it.hasNext()) {
            Hit removed;
            Hit hit = (Hit)it.next();
            if (uri.equals((Object)hit.getId())) {
                it.remove();
                this.handleRemovedHit(hit);
                return hit;
            }
            if (!(hit instanceof HitGroup) || (removed = ((HitGroup)hit).remove(uri)) == null) continue;
            return removed;
        }
        return null;
    }

    public Hit remove(int index) {
        this.updateHits();
        Hit hit = (Hit)this.hits.remove(index);
        this.handleRemovedHit(hit);
        return hit;
    }

    @Deprecated
    public void setError(ErrorMessage error) {
        this.addError(error);
    }

    public void addError(ErrorMessage error) {
        this.getError();
        if (this.errorHit == null) {
            this.add(new DefaultErrorHit(this.getSource(), error));
        } else {
            this.errorHit.addError(error);
        }
    }

    public ErrorHit getErrorHit() {
        this.getError();
        return this.errorHit;
    }

    public DefaultErrorHit removeErrorHit() {
        this.updateHits();
        DefaultErrorHit removed = this.errorHit;
        if (removed != null) {
            this.remove(removed.getId());
        }
        this.errorHit = null;
        return removed;
    }

    public ErrorMessage getError() {
        this.updateHits();
        if (this.errorHit == null) {
            return null;
        }
        return this.errorHit.errors().iterator().next();
    }

    private DefaultErrorHit merge(DefaultErrorHit first, DefaultErrorHit second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        String mergedSource = first.getSource() != null ? first.getSource() : second.getSource();
        ArrayList<ErrorMessage> mergedErrors = new ArrayList<ErrorMessage>();
        mergedErrors.addAll(first.errors());
        mergedErrors.addAll(second.errors());
        return new DefaultErrorHit(mergedSource, mergedErrors);
    }

    private void updateHits() {
        DefaultErrorHit queryErrors = this.consumeAnyQueryErrors();
        if (queryErrors != null) {
            this.add(queryErrors);
        }
    }

    private DefaultErrorHit consumeAnyQueryErrors() {
        if (this.errorHit != null) {
            return null;
        }
        if (this.getQuery() == null) {
            return null;
        }
        if (this.getQuery().errors().isEmpty()) {
            return null;
        }
        List<ErrorMessage> queryErrors = this.getQuery().errors().stream().map(this::toSearchError).collect(Collectors.toList());
        this.getQuery().errors().clear();
        return new DefaultErrorHit(this.getSource(), queryErrors);
    }

    private ErrorMessage toSearchError(com.yahoo.processing.request.ErrorMessage error) {
        if (error instanceof ErrorMessage) {
            return (ErrorMessage)error;
        }
        return new ErrorMessage(error.getCode(), error.getMessage(), error.getDetailedMessage(), error.getCause());
    }

    public void trim(int offset, int numHits) {
        this.updateHits();
        this.ensureSorted();
        int highBound = numHits + offset;
        int currentIndex = -1;
        Iterator i = this.hits.iterator();
        while (i.hasNext()) {
            Hit hit = (Hit)i.next();
            if (hit.isAuxiliary() || ++currentIndex >= offset && currentIndex < highBound) continue;
            i.remove();
            this.handleRemovedHit(hit);
        }
    }

    @Override
    public Iterator<Hit> iterator() {
        this.updateHits();
        this.ensureSorted();
        return new HitIterator(this, (List<Hit>)this.hits);
    }

    public Iterator<Hit> deepIterator() {
        return new DeepHitIterator(this.iterator(), true);
    }

    public Iterator<Hit> unorderedDeepIterator() {
        return new DeepHitIterator(this.unorderedIterator(), false);
    }

    public List<Hit> asList() {
        this.updateHits();
        this.ensureSorted();
        return this.unmodifiableHits;
    }

    public List<Hit> asUnorderedHits() {
        this.updateHits();
        return this.unmodifiableHits;
    }

    public Iterator<Hit> unorderedIterator() {
        this.updateHits();
        return new HitIterator(this, (List<Hit>)this.hits);
    }

    public void sort() {
        if (this.hitOrderer == null) {
            Collections.sort(this.hits);
            this.hitsSorted = true;
        } else {
            this.hitOrderer.order((List<Hit>)this.hits);
            if (this.likelyHitsHaveCorrectValueForSortFields()) {
                this.hitsSorted = true;
            }
        }
    }

    private boolean likelyHitsHaveCorrectValueForSortFields() {
        if (this.hitOrderer == null) {
            return true;
        }
        Set<String> filledFields = this.getFilled();
        return filledFields == null || !filledFields.isEmpty();
    }

    public void setOrderer(HitOrderer hitOrderer) {
        this.hitOrderer = hitOrderer;
        if (this.hits.size() > 1) {
            this.hitsSorted = false;
        }
    }

    public void setSorted(boolean sorted) {
        this.hitsSorted = sorted;
    }

    public HitOrderer getOrderer() {
        return this.hitOrderer;
    }

    public void setDeletionBreaksOrdering(boolean flag) {
        this.deletionBreaksOrdering = flag;
    }

    public boolean getDeletionBreaksOrdering() {
        return this.deletionBreaksOrdering;
    }

    private void ensureSorted() {
        if (!this.orderedHits && !this.hitsSorted && this.likelyHitsHaveCorrectValueForSortFields()) {
            this.sort();
        }
    }

    @Override
    public boolean isCached() {
        if (this.notCachedCount < 1) {
            return true;
        }
        if (this.subgroupCount < 1) {
            return false;
        }
        for (Hit hit : this.hits) {
            if (!(hit instanceof HitGroup) || !hit.isCached()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFilled(String summaryClass) {
        Set<String> filled = this.getFilled();
        return filled == null || filled.contains(summaryClass);
    }

    public void copyOrdering(HitGroup hitGroup) {
        this.setOrderer(hitGroup.getOrderer());
        this.setDeletionBreaksOrdering(hitGroup.getDeletionBreaksOrdering());
        this.setOrdered(hitGroup.orderedHits);
    }

    private void handleNewHit(Hit hit) {
        if (!hit.isAuxiliary()) {
            ++this.concreteHitCount;
        }
        if (hit.getAddNumber() < 0) {
            hit.setAddNumber(this.size());
        }
        this.hitsSorted = false;
        Set<String> hitFilled = hit.getFilled();
        if (hitFilled != null) {
            Set<String> filled = this.getFilledInternal();
            if (filled == null) {
                filled = hitFilled.isEmpty() ? null : (hitFilled.size() == 1 ? Collections.singleton(hitFilled.iterator().next()) : new HashSet<String>(hitFilled));
                this.setFilledInternal(filled);
            } else if (filled.size() == 1) {
                if (!hitFilled.contains(filled.iterator().next())) {
                    filled = null;
                    this.setFilledInternal(filled);
                }
            } else {
                filled.retainAll(hitFilled);
            }
        }
        if (hit instanceof HitGroup) {
            ++this.subgroupCount;
        }
        if (!hit.isCached()) {
            ++this.notCachedCount;
        }
    }

    private void handleRemovedHit(Hit hit) {
        if (!hit.isAuxiliary()) {
            --this.concreteHitCount;
            if (!hit.isCached()) {
                --this.notCachedCount;
            }
        } else if (hit instanceof HitGroup) {
            --this.subgroupCount;
        } else if (hit instanceof DefaultErrorHit) {
            this.errorHit = null;
        }
        if (this.deletionBreaksOrdering) {
            this.hitsSorted = false;
        }
    }

    private void analyzeHit(Hit hit) {
        if (hit instanceof HitGroup) {
            ((HitGroup)hit).analyze();
        }
        if (!hit.isAuxiliary()) {
            ++this.concreteHitCount;
        }
        if (!hit.isCached()) {
            ++this.notCachedCount;
        }
    }

    public void analyze() {
        this.concreteHitCount = 0;
        this.setFilledInternal(null);
        this.notCachedCount = 0;
        HashSet<String> filled = this.getFilledInternal();
        Iterator<Hit> i = this.unorderedIterator();
        while (filled == null && i.hasNext()) {
            Hit hit = i.next();
            this.analyzeHit(hit);
            Set<String> hitFilled = hit.getFilled();
            if (hitFilled == null) continue;
            filled = hitFilled.size() == 1 ? Collections.singleton(hitFilled.iterator().next()) : (hitFilled.isEmpty() ? null : new HashSet<String>(hitFilled));
            this.setFilledInternal(filled);
        }
        String singleKey = null;
        if (filled != null && filled.size() == 1) {
            singleKey = filled.iterator().next();
        }
        while (i.hasNext()) {
            Set<String> hitFilled;
            Hit hit = i.next();
            this.analyzeHit(hit);
            if (filled == null || (hitFilled = hit.getFilled()) == null) continue;
            if (hitFilled.isEmpty()) {
                filled = null;
                this.setFilledInternal(filled);
                continue;
            }
            if (filled.size() == 1) {
                if (hitFilled.contains(singleKey)) continue;
                filled = null;
                this.setFilledInternal(filled);
                singleKey = null;
                continue;
            }
            filled.retainAll(hitFilled);
            if (filled.size() != 1) continue;
            singleKey = (String)filled.iterator().next();
        }
    }

    @Override
    public HitGroup clone() {
        HitGroup hitGroupClone = (HitGroup)super.clone();
        hitGroupClone.hits = new ListenableArrayList(this.hits.size());
        hitGroupClone.unmodifiableHits = Collections.unmodifiableList(hitGroupClone.hits);
        Iterator i = this.hits.iterator();
        while (i.hasNext()) {
            Hit hitClone = ((Hit)i.next()).clone();
            hitGroupClone.hits.add((Object)hitClone);
        }
        if (this.errorHit != null) {
            for (Hit hit : hitGroupClone.asList()) {
                if (!(hit instanceof DefaultErrorHit)) continue;
                hitGroupClone.errorHit = (DefaultErrorHit)hit;
            }
        }
        if (this.getFilledInternal() != null) {
            hitGroupClone.setFilledInternal(new HashSet<String>(this.getFilledInternal()));
        }
        return hitGroupClone;
    }

    @Override
    public void setFillable() {
    }

    @Override
    public void setFilled(String summaryClass) {
    }

    @Override
    public boolean isFillable() {
        return this.fillableHits().iterator().hasNext();
    }

    @Override
    public Set<String> getFilled() {
        Set<String> summaryNames;
        Iterator hitIterator = this.hits.iterator();
        Set<String> firstSummaryNames = this.getSummaryNamesNextFilledHit(hitIterator);
        if (firstSummaryNames == null || firstSummaryNames.isEmpty()) {
            return firstSummaryNames;
        }
        Set<String> intersection = firstSummaryNames;
        while ((summaryNames = this.getSummaryNamesNextFilledHit(hitIterator)) != null) {
            if (intersection.size() == 1) {
                return this.getFilledSingle((String)CollectionUtil.first(intersection), hitIterator);
            }
            boolean notInSet = false;
            if (intersection == firstSummaryNames && intersection.size() == summaryNames.size()) {
                for (String s : summaryNames) {
                    if (intersection.contains(s)) continue;
                    intersection = new HashSet<String>(firstSummaryNames);
                    notInSet = true;
                    break;
                }
            }
            if (!notInSet) continue;
            intersection.retainAll(summaryNames);
        }
        return intersection;
    }

    private Set<String> getSummaryNamesNextFilledHit(Iterator<Hit> hitIterator) {
        while (hitIterator.hasNext()) {
            Set<String> filled = hitIterator.next().getFilled();
            if (filled == null) continue;
            return filled;
        }
        return null;
    }

    private Set<String> getFilledSingle(String summaryName, Iterator<Hit> hitIterator) {
        Set<String> summaryNames;
        do {
            if ((summaryNames = this.getSummaryNamesNextFilledHit(hitIterator)) != null) continue;
            return Collections.singleton(summaryName);
        } while (summaryNames.contains(summaryName));
        return Collections.emptySet();
    }

    private Iterable<Hit> fillableHits() {
        Predicate isFillable = hit -> hit.isFillable();
        return Iterables.filter(this.hits, (Predicate)isFillable);
    }

    public IncomingData<Hit> incoming() {
        return this.incomingHits;
    }

    public ListenableFuture<DataList<Hit>> complete() {
        return this.completedFuture;
    }

    public void addDataListener(Runnable runnable) {
        this.hits.addListener(runnable);
    }
}

