/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.collections.ArraySet;
import com.yahoo.component.provider.ListenableFreezableClass;
import com.yahoo.net.URI;
import com.yahoo.prelude.hitfield.HitField;
import com.yahoo.prelude.hitfield.JSONString;
import com.yahoo.prelude.hitfield.XMLString;
import com.yahoo.processing.Request;
import com.yahoo.processing.response.Data;
import com.yahoo.search.Query;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.Relevance;
import com.yahoo.search.result.StructuredData;
import com.yahoo.text.XML;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Hit
extends ListenableFreezableClass
implements Data,
Comparable<Hit>,
Cloneable {
    private static final String DOCUMENT_ID = "documentid";
    private Map<String, Object> fields = null;
    private Map<String, Object> unmodifiableFieldMap = null;
    private Map<Searcher, Object> searcherSpecificMetaData;
    private URI id;
    private Set<String> types = new ArraySet(2);
    private Relevance relevance;
    private boolean cached = false;
    private Set<String> filled = null;
    private Set<String> unmodifiableFilled = null;
    private String source = null;
    private int addNumber = -1;
    private int sourceNumber;
    private Query query;
    private boolean meta = false;
    private boolean auxiliary = false;
    public static final String RANKFEATURES_FIELD = "rankfeatures";
    public static final String SDDOCNAME_FIELD = "sddocname";

    protected Hit() {
    }

    public Hit(String id) {
        this(id, 1.0);
    }

    public Hit(String id, Query query) {
        this(id, 1.0, query);
    }

    public Hit(String id, double relevance) {
        this(id, new Relevance(relevance));
    }

    public Hit(String id, double relevance, Query query) {
        this(id, new Relevance(relevance), query);
    }

    public Hit(String id, Relevance relevance) {
        this(id, relevance, (String)null);
    }

    public Hit(String id, Relevance relevance, Query query) {
        this(id, relevance, null, query);
    }

    public Hit(String id, double relevance, String source) {
        this(id, new Relevance(relevance), source, null);
    }

    public Hit(String id, double relevance, String source, Query query) {
        this(id, new Relevance(relevance), source);
    }

    public Hit(String id, Relevance relevance, String source) {
        this(id, relevance, source, null);
    }

    public Hit(String id, Relevance relevance, String source, Query query) {
        this.id = new URI(id);
        this.relevance = relevance;
        this.source = source;
        this.query = query;
    }

    public void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Attempt to change id of " + this + " to " + id);
        }
        if (id == null) {
            throw new NullPointerException("Attempt to assign id of " + this + " to null");
        }
        this.assignId(new URI(id));
    }

    public void setId(URI id) {
        if (this.id != null) {
            throw new IllegalStateException("Attempt to change id of " + this + " to " + id);
        }
        this.assignId(id);
    }

    protected final void assignId(URI id) {
        if (id == null) {
            throw new NullPointerException("Attempt to assign id of " + this + " to null");
        }
        this.id = id;
    }

    public URI getId() {
        return this.id;
    }

    public String getDisplayId() {
        String id = null;
        Object idField = this.getField(DOCUMENT_ID);
        if (idField != null) {
            id = idField.toString();
        }
        if (id == null) {
            id = this.getId() == null ? null : this.getId().toString();
        }
        return id;
    }

    public void setRelevance(Relevance relevance) {
        if (relevance == null) {
            throw new NullPointerException("Cannot assign null as relevance");
        }
        this.relevance = relevance;
    }

    public void setRelevance(double relevance) {
        this.setRelevance(new Relevance(relevance));
    }

    public Relevance getRelevance() {
        return this.relevance;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setFillable() {
        if (this.filled == null) {
            this.filled = Collections.emptySet();
            this.unmodifiableFilled = this.filled;
        }
    }

    public void setFilled(String summaryClass) {
        if (this.filled == null || this.filled.size() == 0) {
            this.filled = Collections.singleton(summaryClass);
            this.unmodifiableFilled = this.filled;
        } else if (this.filled.size() == 1) {
            this.filled = new HashSet<String>(this.filled);
            this.unmodifiableFilled = Collections.unmodifiableSet(this.filled);
            this.filled.add(summaryClass);
        } else {
            this.filled.add(summaryClass);
        }
    }

    public boolean isFillable() {
        return this.filled != null;
    }

    public Set<String> getFilled() {
        return this.unmodifiableFilled;
    }

    public boolean isFilled(String summaryClass) {
        return this.filled == null || this.filled.contains(summaryClass);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public final Map<String, Object> fields() {
        return this.getUnmodifiableFieldMap();
    }

    public void reserve(int minSize) {
        this.getFieldMap(minSize);
    }

    public final Iterator<Map.Entry<String, Object>> fieldIterator() {
        return this.getFieldMap().entrySet().iterator();
    }

    public Object getField(String value) {
        return this.fields != null ? this.fields.get(value) : null;
    }

    @Deprecated
    public HitField buildHitField(String key) {
        return this.buildHitField(key, false);
    }

    @Deprecated
    public HitField buildHitField(String key, boolean forceNoPreTokenize) {
        return this.buildHitField(key, forceNoPreTokenize, false);
    }

    public HitField buildHitField(String key, boolean forceNoPreTokenize, boolean forceStringHandling) {
        Object o = this.getField(key);
        if (o == null) {
            return null;
        }
        if (o instanceof HitField) {
            return (HitField)o;
        }
        HitField h = forceNoPreTokenize ? (o instanceof XMLString && !forceStringHandling ? new HitField(key, (XMLString)o, false) : new HitField(key, o.toString(), false)) : (o instanceof XMLString && !forceStringHandling ? new HitField(key, (XMLString)o) : new HitField(key, o.toString()));
        h.setOriginal(o);
        this.getFieldMap().put(key, h);
        return h;
    }

    public Object setField(String key, Object value) {
        return this.getFieldMap().put(key, value);
    }

    public Set<String> types() {
        return this.types;
    }

    public String getTypeString() {
        StringBuilder buffer = new StringBuilder(this.types.size() * 7);
        Iterator<String> i = this.types.iterator();
        while (i.hasNext()) {
            buffer.append(i.next());
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Hit)) {
            return false;
        }
        return this.getId().equals((Object)((Hit)object).getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            throw new IllegalStateException("Id has not been set.");
        }
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(Hit other) {
        int result = other.getRelevance().compareTo(this.getRelevance());
        if (result != 0) {
            return result;
        }
        result = this.getAddNumber() - other.getAddNumber();
        if (result != 0) {
            return result;
        }
        if (this.getId() == null && other.getId() == null) {
            return 0;
        }
        if (other.getId() == null) {
            return -1;
        }
        if (this.getId() == null) {
            return 1;
        }
        return this.getId().compareTo(other.getId());
    }

    public int getAddNumber() {
        return this.addNumber;
    }

    public void setAddNumber(int addNumber) {
        this.addNumber = addNumber;
    }

    public boolean isMeta() {
        return this.meta;
    }

    public void setMeta(boolean meta) {
        this.meta = meta;
    }

    public boolean isAuxiliary() {
        return this.isMeta() || this.auxiliary;
    }

    public void setAuxiliary(boolean auxiliary) {
        this.auxiliary = auxiliary;
    }

    public void clearFields() {
        this.getFieldMap().clear();
    }

    public Object removeField(String field) {
        return this.getFieldMap().remove(field);
    }

    public Set<String> fieldKeys() {
        return this.getFieldMap().keySet();
    }

    public void changeFieldKey(String oldKey, String newKey) {
        Map<String, Object> fieldMap = this.getFieldMap();
        Object value = fieldMap.remove(oldKey);
        fieldMap.put(newKey, value);
    }

    public String toString() {
        return "hit " + this.getId() + " (relevance " + this.getRelevance() + ")";
    }

    public Hit clone() {
        Hit hit = (Hit)super.clone();
        hit.fields = this.fields != null ? new LinkedHashMap<String, Object>(this.fields) : null;
        hit.unmodifiableFieldMap = null;
        hit.types = new LinkedHashSet<String>(this.types);
        if (this.filled != null) {
            hit.setFilledInternal(new HashSet<String>(this.filled));
        }
        return hit;
    }

    public int getSourceNumber() {
        return this.sourceNumber;
    }

    public void setSourceNumber(int number) {
        this.sourceNumber = number;
    }

    public Query getQuery() {
        return this.query;
    }

    public Request request() {
        return this.query;
    }

    public final void setQuery(Query query) {
        if (this.query == null || this instanceof HitGroup) {
            this.query = query;
        }
    }

    public String getFieldXML(String key) {
        Object p = this.getField(key);
        if (p == null) {
            return null;
        }
        if (p instanceof HitField) {
            HitField hf = (HitField)p;
            return hf.quotedContent(false);
        }
        if (p instanceof StructuredData) {
            return p.toString();
        }
        if (p instanceof XMLString || p instanceof JSONString) {
            return p.toString();
        }
        return XML.xmlEscape((String)p.toString(), (boolean)false, (char)'\u001f');
    }

    @Deprecated
    public String getUnboldedField(String key, boolean escape) {
        Object p = this.getField(key);
        if (p == null) {
            return null;
        }
        if (p instanceof HitField) {
            return ((HitField)p).bareContent(escape, false);
        }
        if (p instanceof StructuredData) {
            return p.toString();
        }
        if (p instanceof XMLString || p instanceof JSONString) {
            return p.toString();
        }
        if (escape) {
            return XML.xmlEscape((String)p.toString(), (boolean)false, (char)'\u001f');
        }
        return Hit.stripCharacter('\u001f', p.toString());
    }

    public void setSearcherSpecificMetaData(Searcher searcher, Object data) {
        if (this.searcherSpecificMetaData == null) {
            this.searcherSpecificMetaData = Collections.singletonMap(searcher, data);
        } else if (this.searcherSpecificMetaData.size() == 1) {
            Object tmp = this.searcherSpecificMetaData.get((Object)searcher);
            if (tmp != null) {
                this.searcherSpecificMetaData = Collections.singletonMap(searcher, data);
            } else {
                this.searcherSpecificMetaData = new TreeMap<Searcher, Object>(this.searcherSpecificMetaData);
                this.searcherSpecificMetaData.put(searcher, data);
            }
        } else {
            this.searcherSpecificMetaData.put(searcher, data);
        }
    }

    public Object getSearcherSpecificMetaData(Searcher searcher) {
        return this.searcherSpecificMetaData != null ? this.searcherSpecificMetaData.get((Object)searcher) : null;
    }

    protected final void setFilledInternal(Set<String> filled) {
        this.filled = filled;
        this.unmodifiableFilled = filled != null ? Collections.unmodifiableSet(filled) : null;
    }

    protected final Set<String> getFilledInternal() {
        return this.filled;
    }

    private Map<String, Object> getFieldMap() {
        return this.getFieldMap(16);
    }

    private Map<String, Object> getFieldMap(int minSize) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, Object>(2 * minSize);
        }
        return this.fields;
    }

    private Map<String, Object> getUnmodifiableFieldMap() {
        if (this.unmodifiableFieldMap == null) {
            if (this.fields == null) {
                return Collections.emptyMap();
            }
            this.unmodifiableFieldMap = Collections.unmodifiableMap(this.fields);
        }
        return this.unmodifiableFieldMap;
    }

    public static String stripCharacter(char strip, String toStripFrom) {
        StringBuilder builder = null;
        int lastBadChar = 0;
        for (int i = 0; i < toStripFrom.length(); ++i) {
            if (toStripFrom.charAt(i) != strip) continue;
            if (builder == null) {
                builder = new StringBuilder(toStripFrom.length());
            }
            builder.append(toStripFrom, lastBadChar, i);
            lastBadChar = i + 1;
        }
        if (builder == null) {
            return toStripFrom;
        }
        if (lastBadChar < toStripFrom.length()) {
            builder.append(toStripFrom, lastBadChar, toStripFrom.length());
        }
        return builder.toString();
    }
}

