/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.container.protect.Error;

public class ErrorMessage
extends com.yahoo.processing.request.ErrorMessage {
    public static final int NULL_QUERY = Error.NULL_QUERY.code;
    private String source = null;
    public static final int timeoutCode = Error.TIMEOUT.code;
    public static final int emptyDocsumsCode = Error.EMPTY_DOCUMENTS.code;

    public ErrorMessage(int code, String message) {
        super(code, message);
    }

    public ErrorMessage(int code, String message, String detailedMessage) {
        super(code, message, detailedMessage);
    }

    public ErrorMessage(int code, String message, String detailedMessage, Throwable cause) {
        super(code, message, detailedMessage, cause);
    }

    public static ErrorMessage createNoBackendsInService(String detailedMessage) {
        return new ErrorMessage(Error.NO_BACKENDS_IN_SERVICE.code, "No backends in service. Try later", detailedMessage);
    }

    public static ErrorMessage createNullQuery(String detailedMessage) {
        return new ErrorMessage(NULL_QUERY, "Null query", detailedMessage);
    }

    public static ErrorMessage createRequestTooLarge(String detailedMessage) {
        return new ErrorMessage(Error.REQUEST_TOO_LARGE.code, "Request too large", detailedMessage);
    }

    public static ErrorMessage createIllegalQuery(String detailedMessage) {
        return new ErrorMessage(Error.ILLEGAL_QUERY.code, "Illegal query", detailedMessage);
    }

    public static ErrorMessage createInvalidQueryParameter(String detailedMessage) {
        return new ErrorMessage(Error.INVALID_QUERY_PARAMETER.code, "Invalid query parameter", detailedMessage);
    }

    public static ErrorMessage createInvalidQueryParameter(String detailedMessage, Throwable cause) {
        return new ErrorMessage(Error.INVALID_QUERY_PARAMETER.code, "Invalid query parameter", detailedMessage, cause);
    }

    public static ErrorMessage createUnspecifiedError(String detailedMessage) {
        return new ErrorMessage(Error.UNSPECIFIED.code, "Unspecified error", detailedMessage);
    }

    public static ErrorMessage createUnspecifiedError(String detailedMessage, Throwable cause) {
        return new ErrorMessage(Error.UNSPECIFIED.code, "Unspecified error", detailedMessage, cause);
    }

    public static ErrorMessage createErrorInPluginSearcher(String detailedMessage) {
        return new ErrorMessage(Error.ERROR_IN_PLUGIN.code, "Error in plugin Searcher", detailedMessage);
    }

    public static ErrorMessage createErrorInPluginSearcher(String detailedMessage, Throwable cause) {
        return new ErrorMessage(Error.ERROR_IN_PLUGIN.code, "Error in plugin Searcher", detailedMessage, cause);
    }

    public static ErrorMessage createInvalidQueryTransformation(String detailedMessage) {
        return new ErrorMessage(Error.INVALID_QUERY_TRANSFORMATION.code, "Invalid query transformation", detailedMessage);
    }

    public static ErrorMessage createServerIsMisconfigured(String detailedMessage) {
        return new ErrorMessage(Error.SERVER_IS_MISCONFIGURED.code, "Service is misconfigured", detailedMessage);
    }

    public static ErrorMessage createBackendCommunicationError(String detailedMessage) {
        return new ErrorMessage(Error.BACKEND_COMMUNICATION_ERROR.code, "Backend communication error", detailedMessage);
    }

    public static ErrorMessage createNoAnswerWhenPingingNode(String detailedMessage) {
        return new ErrorMessage(Error.NO_ANSWER_WHEN_PINGING_NODE.code, "No answer when pinging node", detailedMessage);
    }

    public static ErrorMessage createTimeout(String detailedMessage) {
        return new ErrorMessage(timeoutCode, "Timed out", detailedMessage);
    }

    public static ErrorMessage createEmptyDocsums(String detailedMessage) {
        return new ErrorMessage(emptyDocsumsCode, "Empty document summaries", detailedMessage);
    }

    public static ErrorMessage createUnauthorized(String detailedMessage) {
        return new ErrorMessage(Error.UNAUTHORIZED.code, "Client not authenticated.", detailedMessage);
    }

    public static ErrorMessage createForbidden(String detailedMessage) {
        return new ErrorMessage(Error.FORBIDDEN.code, "Forbidden.", detailedMessage);
    }

    public static ErrorMessage createNotFound(String detailedMessage) {
        return new ErrorMessage(Error.NOT_FOUND.code, "Resource not found.", detailedMessage);
    }

    public static ErrorMessage createBadRequest(String detailedMessage) {
        return new ErrorMessage(Error.BAD_REQUEST.code, "Bad request.", detailedMessage);
    }

    public static ErrorMessage createInternalServerError(String detailedMessage) {
        return new ErrorMessage(Error.INTERNAL_SERVER_ERROR.code, "Internal server error.", detailedMessage);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        return super.hashCode() + (this.source == null ? 0 : 31 * this.source.hashCode());
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)((Object)o);
        return !(this.source != null ? !this.source.equals(other.source) : other.source != null);
    }

    public String toString() {
        return (this.source == null ? "" : "Source '" + this.source + "': ") + super.toString();
    }

    public ErrorMessage clone() {
        return (ErrorMessage)super.clone();
    }

    public static ErrorMessage from(com.yahoo.processing.request.ErrorMessage error) {
        if (error instanceof ErrorMessage) {
            return (ErrorMessage)error;
        }
        return new ErrorMessage(error.getCode(), error.getMessage(), error.getDetailedMessage(), error.getCause());
    }
}

