/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.collections.ArraySet;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.Relevance;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultErrorHit
extends Hit
implements ErrorHit,
Cloneable {
    private List<ErrorMessage> errors = new ArrayList<ErrorMessage>();

    public DefaultErrorHit(String source, ErrorMessage error) {
        super("error:" + source, new Relevance(Double.POSITIVE_INFINITY), source);
        this.addError(error);
    }

    public DefaultErrorHit(String source, List<ErrorMessage> errors) {
        super("error:" + source, new Relevance(Double.POSITIVE_INFINITY), source);
        for (ErrorMessage error : errors) {
            this.addError(error);
        }
    }

    @Override
    public void setSource(String source) {
        super.setSource(source);
        Iterator<ErrorMessage> i = this.errorIterator();
        while (i.hasNext()) {
            ErrorMessage error = i.next();
            if (error.getSource() != null) continue;
            error.setSource(source);
        }
    }

    @Override
    @Deprecated
    public ErrorMessage getMainError() {
        return this.errors.get(0);
    }

    private void removeAndAdd(ErrorMessage error) {
        this.errors.remove((Object)error);
        this.errors.add(error);
    }

    @Override
    public void addError(ErrorMessage error) {
        if (error.getSource() == null) {
            error.setSource(this.getSource());
        }
        this.removeAndAdd(error);
    }

    @Override
    public void addErrors(ErrorHit errorHit) {
        Iterator<? extends ErrorMessage> i = errorHit.errorIterator();
        while (i.hasNext()) {
            this.addError(i.next());
        }
    }

    public Iterator<ErrorMessage> errorIterator() {
        return this.errors.iterator();
    }

    @Override
    public Set<ErrorMessage> errors() {
        ArraySet s = new ArraySet(this.errors.size());
        s.addAll(this.errors);
        return s;
    }

    @Override
    public String toString() {
        return "Error: " + this.errors.get(0).toString();
    }

    @Override
    public boolean isMeta() {
        return true;
    }

    @Override
    public boolean hasOnlyErrorCode(int code) {
        for (ErrorMessage error : this.errors) {
            if (error.getCode() == code) continue;
            return false;
        }
        return true;
    }

    @Override
    public DefaultErrorHit clone() {
        DefaultErrorHit clone = (DefaultErrorHit)super.clone();
        clone.errors = new ArrayList<ErrorMessage>(this.errors);
        return clone;
    }
}

