/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.querytransform.LowercasingConfig;
import com.yahoo.search.querytransform.LowercasingSearcher;

@After(value={"Stemming", "AccentRemoval"})
@Provides(value={"LowerCasing"})
public class VespaLowercasingSearcher
extends LowercasingSearcher {
    public static final String LOWERCASING = "LowerCasing";

    public VespaLowercasingSearcher(LowercasingConfig cfg) {
        super(cfg);
    }

    @Override
    public boolean shouldLowercase(WordItem word, IndexFacts.Session indexFacts) {
        if (word.isLowercased()) {
            return false;
        }
        Index index = indexFacts.getIndex(word.getIndexName());
        return index.isLowercase() || index.isAttribute();
    }
}

