/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.serializer;

import com.yahoo.prelude.query.Item;
import com.yahoo.search.query.textserialize.item.ItemExecutorRegistry;
import com.yahoo.search.query.textserialize.item.ListUtil;
import com.yahoo.search.query.textserialize.serializer.DispatchForm;
import com.yahoo.search.query.textserialize.serializer.ItemIdMapper;
import java.util.List;
import java.util.Map;

class Serializer {
    Serializer() {
    }

    static String serialize(Object child, ItemIdMapper itemIdMapper) {
        if (child instanceof DispatchForm) {
            return ((DispatchForm)child).serialize(itemIdMapper);
        }
        if (child instanceof Item) {
            return Serializer.serializeItem((Item)child, itemIdMapper);
        }
        if (child instanceof String) {
            return Serializer.serializeString((String)child);
        }
        if (child instanceof Number) {
            return child.toString();
        }
        if (child instanceof Map) {
            return Serializer.serializeMap((Map)child, itemIdMapper);
        }
        if (child instanceof List) {
            return Serializer.serializeList((List)child, itemIdMapper);
        }
        throw new IllegalArgumentException("Can't serialize type " + child.getClass());
    }

    private static String serializeString(String string) {
        return '\"' + string.replace("\\", "\\\\").replace("\"", "\\\"") + '\"';
    }

    static String serializeList(List<?> list, ItemIdMapper itemIdMapper) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        if (!list.isEmpty()) {
            builder.append(Serializer.serialize(ListUtil.first(list), itemIdMapper));
            for (Object element : ListUtil.butFirst(list)) {
                builder.append(", ").append(Serializer.serialize(element, itemIdMapper));
            }
        }
        builder.append(']');
        return builder.toString();
    }

    static String serializeMap(Map<?, ?> map, ItemIdMapper itemIdMapper) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (!map.isEmpty()) {
            Serializer.serializeEntry(builder, ListUtil.first(map.entrySet()), itemIdMapper);
            for (Map.Entry<?, ?> entry : ListUtil.butFirst(map.entrySet())) {
                builder.append(", ");
                Serializer.serializeEntry(builder, entry, itemIdMapper);
            }
        }
        builder.append('}');
        return builder.toString();
    }

    static void serializeEntry(StringBuilder builder, Map.Entry<?, ?> entry, ItemIdMapper itemIdMapper) {
        builder.append(Serializer.serialize(entry.getKey(), itemIdMapper)).append(' ').append(Serializer.serialize(entry.getValue(), itemIdMapper));
    }

    static String serializeItem(Item item, ItemIdMapper itemIdMapper) {
        return ItemExecutorRegistry.getByType(item.getItemType()).itemToForm(item, itemIdMapper).serialize(itemIdMapper);
    }
}

