/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.rewrite;

import com.google.inject.Inject;
import com.yahoo.component.ComponentId;
import com.yahoo.config.FileReference;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.fsa.FSA;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.rewrite.RewriterConstants;
import com.yahoo.search.query.rewrite.RewriterUtils;
import com.yahoo.search.query.rewrite.RewritesConfig;
import com.yahoo.search.searchchain.Execution;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class QueryRewriteSearcher
extends Searcher {
    private boolean isOk = false;
    protected final Logger logger = Logger.getLogger(QueryRewriteSearcher.class.getName());
    protected HashMap<String, Object> rewriterDicts = new HashMap();

    @Inject
    protected QueryRewriteSearcher(ComponentId id, FileAcquirer fileAcquirer, RewritesConfig config) {
        super(id);
        RewriterUtils.log(this.logger, "In QueryRewriteSearcher(ComponentId id, FileAcquirer fileAcquirer, RewritesConfig config)");
        this.isOk = this.loadFSADicts(fileAcquirer, config, null);
        boolean bl = this.isOk = this.isOk && this.configure(fileAcquirer, config, null);
        if (this.isOk) {
            RewriterUtils.log(this.logger, "Rewriter is configured properly");
        } else {
            RewriterUtils.log(this.logger, "Rewriter is not configured properly");
        }
    }

    protected QueryRewriteSearcher(RewritesConfig config, HashMap<String, File> fileList) {
        RewriterUtils.log(this.logger, "In QueryRewriteSearcher(RewritesConfig config, HashMap<String, File> fileList)");
        this.isOk = this.loadFSADicts(null, config, fileList);
        boolean bl = this.isOk = this.isOk && this.configure(null, config, fileList);
        if (this.isOk) {
            RewriterUtils.log(this.logger, "Rewriter is configured properly");
        } else {
            RewriterUtils.log(this.logger, "Rewriter is not configured properly");
        }
    }

    protected QueryRewriteSearcher(ComponentId id) {
        super(id);
        RewriterUtils.log(this.logger, "In QueryRewriteSearcher(Component id)");
        RewriterUtils.log(this.logger, "Configuring rewriter: " + this.getRewriterName());
        this.isOk = true;
        RewriterUtils.log(this.logger, "Rewriter is configured properly");
    }

    protected QueryRewriteSearcher() {
        RewriterUtils.log(this.logger, "In QueryRewriteSearcher()");
        RewriterUtils.log(this.logger, "Configuring rewriter: " + this.getRewriterName());
        this.isOk = true;
        RewriterUtils.log(this.logger, "Rewriter is configured properly");
    }

    private boolean loadFSADicts(FileAcquirer fileAcquirer, RewritesConfig config, HashMap<String, File> fileList) throws RuntimeException {
        String rewriterName = this.getRewriterName();
        if (rewriterName == null) {
            RewriterUtils.error(this.logger, "Rewriter required method is not properly implemented: ");
            return false;
        }
        RewriterUtils.log(this.logger, "Configuring rewriter: " + rewriterName);
        if (config == null || fileAcquirer == null && fileList == null) {
            RewriterUtils.log(this.logger, "No FSA dictionary file need to be loaded");
            return true;
        }
        if (config.fsaDict() == null) {
            RewriterUtils.error(this.logger, "FSADict is not properly set in config");
            return false;
        }
        RewriterUtils.log(this.logger, "Loading rewriter dictionaries");
        ListIterator<RewritesConfig.FsaDict> fsaList = config.fsaDict().listIterator();
        if (!fsaList.hasNext()) {
            RewriterUtils.log(this.logger, "Loading default dictionaries");
            HashMap<String, String> defaultFSAs = this.getDefaultFSAs();
            if (defaultFSAs == null) {
                RewriterUtils.log(this.logger, "No default FSA dictionary is configured");
                return true;
            }
            Iterator<Map.Entry<String, String>> defaultFSAList = defaultFSAs.entrySet().iterator();
            while (defaultFSAList.hasNext()) {
                try {
                    Map.Entry<String, String> currFSA = defaultFSAList.next();
                    String fsaName = currFSA.getKey();
                    String fsaPath = currFSA.getValue();
                    RewriterUtils.log(this.logger, "FSA file location for " + fsaName + ": " + fsaPath);
                    FSA fsa = RewriterUtils.loadFSA(RewriterConstants.DEFAULT_DICT_DIR + fsaPath, null);
                    this.rewriterDicts.put(fsaName, fsa);
                }
                catch (IOException e) {
                    RewriterUtils.error(this.logger, "Error loading FSA dictionary: " + e.getMessage());
                    return false;
                }
            }
        } else {
            while (fsaList.hasNext()) {
                try {
                    RewritesConfig.FsaDict currFSA = fsaList.next();
                    String fsaName = currFSA.name();
                    FileReference fsaPath = currFSA.path();
                    RewriterUtils.log(this.logger, "FSA file location for " + fsaName + ": " + fsaPath);
                    File fsaFile = null;
                    if (fileAcquirer != null) {
                        fsaFile = fileAcquirer.waitFor(fsaPath, 5L, TimeUnit.MINUTES);
                    } else if (fileList != null) {
                        fsaFile = fileList.get(fsaName);
                    }
                    if (fsaFile == null) {
                        RewriterUtils.error(this.logger, "Error loading FSA dictionary file handler");
                        return false;
                    }
                    FSA fsa = RewriterUtils.loadFSA(fsaFile, null);
                    this.rewriterDicts.put(fsaName, fsa);
                }
                catch (InterruptedException e1) {
                    RewriterUtils.error(this.logger, "Error loading FSA dictionary file handler: " + e1.getMessage());
                    return false;
                }
                catch (IOException e2) {
                    RewriterUtils.error(this.logger, "Error loading FSA dictionary: " + e2.getMessage());
                    return false;
                }
            }
        }
        RewriterUtils.log(this.logger, "Successfully loaded rewriter dictionaries");
        return true;
    }

    public abstract boolean configure(FileAcquirer var1, RewritesConfig var2, HashMap<String, File> var3) throws RuntimeException;

    @Override
    public Result search(Query query, Execution execution) {
        RewriterUtils.log(this.logger, query, "Executing " + this.getRewriterName());
        if (!this.isOk) {
            RewriterUtils.error(this.logger, query, "Rewriter is not properly initialized");
            return execution.search(query);
        }
        RewriterUtils.log(this.logger, query, "Original query: " + query.toDetailString());
        HashMap<String, Object> rewriteMeta = RewriterUtils.getRewriteMeta(query);
        String prevDictKey = (String)rewriteMeta.get("DictKey");
        Boolean prevRewritten = (Boolean)rewriteMeta.get("Rewritten");
        if (prevRewritten.booleanValue() && this.getSkipRewriterIfRewritten()) {
            RewriterUtils.log(this.logger, query, "Skipping rewriter since the query has been rewritten");
            return execution.search(query);
        }
        HashMap<String, Object> rewriterResult = null;
        Query originalQueryObj = query.clone();
        try {
            rewriterResult = this.rewrite(query, prevDictKey);
        }
        catch (RuntimeException e) {
            RewriterUtils.error(this.logger, originalQueryObj, "Error executing this rewriter, skipping to next rewriter: " + e.getMessage());
            return execution.search(originalQueryObj);
        }
        if (rewriterResult == null) {
            RewriterUtils.error(this.logger, originalQueryObj, "Rewriter result are not set properly, skipping to next rewriter");
            return execution.search(originalQueryObj);
        }
        Boolean rewritten = (Boolean)rewriterResult.get("Rewritten");
        String dictKey = (String)rewriterResult.get("DictKey");
        if (rewritten == null || dictKey == null) {
            RewriterUtils.error(this.logger, originalQueryObj, "Rewriter result are not set properly, skipping to next rewriter");
            return execution.search(originalQueryObj);
        }
        rewriteMeta.put("Rewritten", rewritten != false || prevRewritten != false);
        rewriteMeta.put("DictKey", dictKey);
        RewriterUtils.setRewriteMeta(query, rewriteMeta);
        RewriterUtils.log(this.logger, query, "Final query: " + query.toDetailString());
        return execution.search(query);
    }

    protected abstract HashMap<String, Object> rewrite(Query var1, String var2) throws RuntimeException;

    protected abstract boolean getSkipRewriterIfRewritten();

    public abstract String getRewriterName();

    public abstract HashMap<String, String> getDefaultFSAs();

    protected String getQPConfig(Query query, String paramName) {
        return RewriterUtils.getQPConfig(query, this.getRewriterName(), paramName);
    }

    protected String getRewriteFromFSA(Query query, String dictName, String key) throws RuntimeException {
        return RewriterUtils.getRewriteFromFSA(query, this.rewriterDicts, dictName, key);
    }
}

