/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.fs4.MapEncoder;
import com.yahoo.search.query.ranking.RankProperties;
import com.yahoo.tensor.Tensor;
import com.yahoo.text.JSON;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class RankFeatures
implements Cloneable {
    private final Map<String, Object> features;

    public RankFeatures() {
        this(new LinkedHashMap<String, Object>());
    }

    private RankFeatures(Map<String, Object> features) {
        this.features = features;
    }

    public void put(String name, String value) {
        this.features.put(name, value);
    }

    public void put(String name, Tensor value) {
        this.features.put(name, value);
    }

    public String get(String name) {
        Object value = this.features.get(name);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Object getObject(String name) {
        return this.features.get(name);
    }

    public Optional<Tensor> getTensor(String name) {
        Object feature = this.features.get(name);
        if (feature == null) {
            return Optional.empty();
        }
        if (feature instanceof Tensor) {
            return Optional.of((Tensor)feature);
        }
        throw new IllegalArgumentException("Expected a tensor value of '" + name + "' but has " + feature);
    }

    public Map<String, Object> asMap() {
        return this.features;
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    public void prepare(RankProperties rankProperties) {
        if (this.isEmpty()) {
            return;
        }
        ArrayList<String> featuresToRemove = new ArrayList<String>();
        ArrayList<String> propertiesToInsert = new ArrayList<String>();
        for (String key : this.features.keySet()) {
            if (key.startsWith("query(") && key.endsWith(")")) {
                featuresToRemove.add(key);
                propertiesToInsert.add(key.substring("query(".length(), key.length() - 1));
                continue;
            }
            if (!key.startsWith("$")) continue;
            featuresToRemove.add(key);
            propertiesToInsert.add(key.substring(1));
        }
        for (int i = 0; i < featuresToRemove.size(); ++i) {
            rankProperties.put((String)propertiesToInsert.get(i), this.features.remove(featuresToRemove.get(i)));
        }
    }

    public int encode(ByteBuffer buffer) {
        return MapEncoder.encodeMap("feature", this.features, buffer);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RankFeatures)) {
            return false;
        }
        return this.features.equals(((RankFeatures)other).features);
    }

    public int hashCode() {
        return this.features.hashCode();
    }

    public RankFeatures clone() {
        return new RankFeatures(new LinkedHashMap<String, Object>(this.features));
    }

    public String toString() {
        return JSON.encode(this.features);
    }
}

