/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.parser;

import com.yahoo.prelude.query.parser.AdvancedParser;
import com.yahoo.prelude.query.parser.AllParser;
import com.yahoo.prelude.query.parser.AnyParser;
import com.yahoo.prelude.query.parser.PhraseParser;
import com.yahoo.prelude.query.parser.ProgrammaticParser;
import com.yahoo.prelude.query.parser.WebParser;
import com.yahoo.search.Query;
import com.yahoo.search.query.parser.Parser;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.yql.YqlParser;

public final class ParserFactory {
    private ParserFactory() {
    }

    public static Parser newInstance(Query.Type type, ParserEnvironment environment) {
        switch (type) {
            case ALL: {
                return new AllParser(environment);
            }
            case ANY: {
                return new AnyParser(environment);
            }
            case PHRASE: {
                return new PhraseParser(environment);
            }
            case ADVANCED: {
                return new AdvancedParser(environment);
            }
            case WEB: {
                return new WebParser(environment);
            }
            case PROGRAMMATIC: {
                return new ProgrammaticParser();
            }
            case YQL: {
                return new YqlParser(environment);
            }
        }
        throw new UnsupportedOperationException(type.toString());
    }
}

