/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.parser;

import com.yahoo.language.Language;
import com.yahoo.search.query.Model;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class Parsable {
    private final Set<String> sourceList = new HashSet<String>();
    private final Set<String> restrictList = new HashSet<String>();
    private String query;
    private String filter;
    private String defaultIndexName;
    private Language language;
    private Optional<Language> explicitLanguage = Optional.empty();
    private Optional<Model> model = Optional.empty();

    public String getQuery() {
        return this.query;
    }

    public Parsable setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public Parsable setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getDefaultIndexName() {
        return this.defaultIndexName;
    }

    public Parsable setDefaultIndexName(String defaultIndexName) {
        this.defaultIndexName = defaultIndexName;
        return this;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Language getOrDetectLanguage(String languageDetectionText) {
        if (this.language != null && this.language != Language.UNKNOWN) {
            return this.language;
        }
        if (this.model.isPresent()) {
            return this.model.get().getParsingLanguage(languageDetectionText);
        }
        return Language.UNKNOWN;
    }

    public Parsable setLanguage(Language language) {
        Objects.requireNonNull(language, "Language cannot be null");
        this.language = language;
        return this;
    }

    public Optional<Language> getExplicitLanguage() {
        return this.explicitLanguage;
    }

    public Parsable setExplicitLanguage(Optional<Language> language) {
        Objects.requireNonNull(language, "Explicit language cannot be null");
        this.explicitLanguage = language;
        return this;
    }

    public Parsable setModel(Model model) {
        Objects.requireNonNull(model, "Model cannot be null");
        this.model = Optional.of(model);
        return this;
    }

    public Set<String> getSources() {
        return this.sourceList;
    }

    public Parsable addSource(String sourceName) {
        this.sourceList.add(sourceName);
        return this;
    }

    public Parsable addSources(Collection<String> sourceNames) {
        this.sourceList.addAll(sourceNames);
        return this;
    }

    public Set<String> getRestrict() {
        return this.restrictList;
    }

    public Parsable addRestrict(String restrictName) {
        this.restrictList.add(restrictName);
        return this;
    }

    public Parsable addRestricts(Collection<String> restrictNames) {
        this.restrictList.addAll(restrictNames);
        return this;
    }

    public static Parsable fromQueryModel(Model model) {
        return new Parsable().setModel(model).setQuery(model.getQueryString()).setFilter(model.getFilter()).setExplicitLanguage(Optional.ofNullable(model.getLanguage())).setDefaultIndexName(model.getDefaultIndex()).addSources(model.getSources()).addRestricts(model.getRestrict());
    }
}

