/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates;

import com.google.inject.Inject;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.intent.model.IntentModel;
import com.yahoo.search.pagetemplates.PageTemplate;
import com.yahoo.search.pagetemplates.PageTemplateRegistry;
import com.yahoo.search.pagetemplates.PageTemplatesConfig;
import com.yahoo.search.pagetemplates.config.PageTemplateConfigurer;
import com.yahoo.search.pagetemplates.engine.Organizer;
import com.yahoo.search.pagetemplates.engine.Resolution;
import com.yahoo.search.pagetemplates.engine.Resolver;
import com.yahoo.search.pagetemplates.engine.resolvers.ResolverRegistry;
import com.yahoo.search.pagetemplates.model.Choice;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.Source;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Provides(value={"PageTemplates"})
public class PageTemplateSearcher
extends Searcher {
    public static final CompoundName pagePageTemplateListName = new CompoundName("page.PageTemplateList");
    public static final CompoundName pageIdListName = new CompoundName("page.idList");
    public static final CompoundName pageIdName = new CompoundName("page.id");
    public static final CompoundName pageResolverName = new CompoundName("page.resolver");
    private final ResolverRegistry resolverRegistry;
    private final Organizer organizer = new Organizer();
    private final PageTemplateRegistry templateRegistry;

    @Inject
    public PageTemplateSearcher(PageTemplatesConfig pageTemplatesConfig, ComponentRegistry<Resolver> resolverRegistry) {
        this(PageTemplateConfigurer.toRegistry(pageTemplatesConfig), resolverRegistry.allComponents());
    }

    public PageTemplateSearcher(PageTemplateRegistry templateRegistry, Resolver ... resolvers) {
        this(templateRegistry, Arrays.asList(resolvers));
    }

    private PageTemplateSearcher(PageTemplateRegistry templateRegistry, List<Resolver> resolvers) {
        this.templateRegistry = templateRegistry;
        templateRegistry.freeze();
        this.resolverRegistry = new ResolverRegistry(resolvers);
    }

    @Override
    public Result search(Query query, Execution execution) {
        List<PageElement> pages = this.selectPageTemplates(query);
        if (pages.isEmpty()) {
            return execution.search(query);
        }
        this.addSources(pages, query);
        query.properties().set(pagePageTemplateListName, pages);
        Result result = execution.search(query);
        Choice pageTemplateChoice = Choice.createSingletons(pages);
        Resolution resolution = this.selectResolver(query).resolve(pageTemplateChoice, query, result);
        this.organizer.organize(pageTemplateChoice, resolution, result);
        return result;
    }

    private List<PageElement> selectPageTemplates(Query query) {
        String pageIdString;
        List<String> pageIds = (List<String>)query.properties().get(pageIdListName);
        if (pageIds == null && (pageIdString = query.properties().getString(pageIdName, "").trim()).length() > 0) {
            pageIds = Arrays.asList(pageIdString.split(" "));
        }
        if (pageIds == null) {
            PageElement defaultPage = (PageElement)this.templateRegistry.getComponent("default");
            return defaultPage == null ? Collections.emptyList() : Collections.singletonList(defaultPage);
        }
        ArrayList<PageElement> pages = new ArrayList<PageElement>(pageIds.size());
        for (String pageId : pageIds) {
            PageTemplate page = (PageTemplate)this.templateRegistry.getComponent(pageId);
            if (page == null) {
                query.errors().add(ErrorMessage.createInvalidQueryParameter("Could not resolve requested page template '" + pageId + "'"));
                continue;
            }
            pages.add(page);
        }
        return pages;
    }

    private Resolver selectResolver(Query query) {
        String resolverId = query.properties().getString(pageResolverName);
        if (resolverId == null) {
            return this.resolverRegistry.defaultResolver();
        }
        Resolver resolver = (Resolver)((Object)this.resolverRegistry.getComponent(resolverId));
        if (resolver == null) {
            throw new IllegalArgumentException("No page template resolver '" + resolverId + "'");
        }
        return resolver;
    }

    private void addSources(List<PageElement> pages, Query query) {
        HashSet<Source> pageSources = new HashSet<Source>();
        for (PageElement page : pages) {
            pageSources.addAll(((PageTemplate)page).getSources());
        }
        this.addErrorIfSameSourceMultipleTimes(pages, pageSources, query);
        if (query.getModel().getSources().size() > 0) {
            this.addParametersForIncludedSources(pageSources, query);
            return;
        }
        if (pageSources.contains(Source.any)) {
            IntentModel intentModel = IntentModel.getFrom(query);
            if (intentModel != null) {
                query.getModel().getSources().addAll(intentModel.getSourceNames());
                this.addPageTemplateSources(pageSources, query);
            }
        } else {
            this.addPageTemplateSources(pageSources, query);
        }
    }

    private void addPageTemplateSources(Set<Source> pageSources, Query query) {
        for (Source pageSource : pageSources) {
            if (pageSource == Source.any) continue;
            query.getModel().getSources().add(pageSource.getName());
            this.addParameters(pageSource, query);
        }
    }

    private void addParametersForIncludedSources(Set<Source> sources, Query query) {
        for (Source source : sources) {
            if (source.parameters().size() <= 0 || !query.getModel().getSources().contains(source.getName())) continue;
            this.addParameters(source, query);
        }
    }

    private void addParameters(Source source, Query query) {
        for (Map.Entry<String, String> parameter : source.parameters().entrySet()) {
            query.properties().set("source." + source.getName() + "." + parameter.getKey(), parameter.getValue());
        }
    }

    private void addErrorIfSameSourceMultipleTimes(List<PageElement> pages, Set<Source> sources, Query query) {
        HashSet<String> sourceNames = new HashSet<String>();
        for (Source source : sources) {
            if (sourceNames.contains(source.getName())) {
                query.errors().add(ErrorMessage.createInvalidQueryParameter("Querying the same source multiple times with different parameter sets as part of one query is not supported. " + pages + " requests this for source '" + source + "'"));
            }
            sourceNames.add(source.getName());
        }
    }
}

