/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.FunctionNode;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.StringValue;
import java.util.Arrays;

public class UcaFunction
extends FunctionNode {
    private final String locale;
    private final String strength;

    public UcaFunction(GroupingExpression exp, String locale) {
        super("uca", Arrays.asList(exp, new StringValue(locale)));
        this.locale = locale;
        this.strength = "TERTIARY";
    }

    public UcaFunction(GroupingExpression exp, String locale, String strength) {
        super("uca", Arrays.asList(exp, new StringValue(locale), new StringValue(strength)));
        if (!this.validStrength(strength)) {
            throw new IllegalArgumentException("Not a valid UCA strength: " + strength);
        }
        this.locale = locale;
        this.strength = strength;
    }

    private boolean validStrength(String strength) {
        return strength.equals("PRIMARY") || strength.equals("SECONDARY") || strength.equals("TERTIARY") || strength.equals("QUATERNARY") || strength.equals("IDENTICAL");
    }

    public String getLocale() {
        return this.locale;
    }

    public String getStrength() {
        return this.strength;
    }
}

