/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.google.inject.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.grouping.GroupingQueryParser;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.UnavailableAttributeException;
import com.yahoo.search.grouping.request.AttributeValue;
import com.yahoo.search.grouping.request.ExpressionVisitor;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.config.search.AttributesConfig;
import java.util.HashSet;
import java.util.Set;

@Before(value={"backend"})
@After(value={"SelectParameterParsing"})
@Provides(value={"GroupingValidated"})
public class GroupingValidator
extends Searcher {
    public static final String GROUPING_VALIDATED = "GroupingValidated";
    public static final CompoundName PARAM_ENABLED = new CompoundName("validate_" + GroupingQueryParser.PARAM_REQUEST);
    private final Set<String> attributeNames = new HashSet<String>();
    private final String clusterName;
    private final boolean enabled;

    @Inject
    public GroupingValidator(QrSearchersConfig qrsConfig, ClusterConfig clusterConfig, AttributesConfig attributesConfig) {
        int clusterId = clusterConfig.clusterId();
        QrSearchersConfig.Searchcluster.Indexingmode.Enum indexingMode = qrsConfig.searchcluster(clusterId).indexingmode();
        this.enabled = indexingMode != QrSearchersConfig.Searchcluster.Indexingmode.STREAMING;
        this.clusterName = this.enabled ? qrsConfig.searchcluster(clusterId).name() : null;
        for (AttributesConfig.Attribute attr : attributesConfig.attribute()) {
            this.attributeNames.add(attr.name());
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        if (this.enabled && query.properties().getBoolean(PARAM_ENABLED, true)) {
            MyVisitor visitor = new MyVisitor();
            for (GroupingRequest req : GroupingRequest.getRequests(query)) {
                req.getRootOperation().visitExpressions(visitor);
            }
        }
        return execution.search(query);
    }

    private class MyVisitor
    implements ExpressionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitExpression(GroupingExpression exp) {
            if (exp instanceof AttributeValue) {
                String name = ((AttributeValue)exp).getAttributeName();
                if (!GroupingValidator.this.attributeNames.contains(name)) {
                    throw new UnavailableAttributeException(GroupingValidator.this.clusterName, name);
                }
            }
        }
    }
}

