/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.vespa;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NearItem;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.ONearItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.prelude.query.WordItem;
import java.util.ListIterator;

public class QueryMarshaller {
    private boolean atRoot = true;

    public String marshal(Item root) {
        if (root == null || root instanceof NullItem) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        this.marshal(root, s);
        this.atRoot = true;
        return s.toString();
    }

    private void marshal(Item root, StringBuilder s) {
        switch (root.getItemType()) {
            case OR: {
                this.marshalOr((OrItem)root, s);
                break;
            }
            case AND: {
                this.marshalAnd((CompositeItem)root, s);
                break;
            }
            case NOT: {
                this.marshalNot((NotItem)root, s);
                break;
            }
            case RANK: {
                this.marshalRank((RankItem)root, s);
                break;
            }
            case WORD: 
            case INT: 
            case PREFIX: 
            case SUBSTRING: 
            case SUFFIX: {
                this.marshalWord((TermItem)root, s);
                break;
            }
            case PHRASE: {
                if (root instanceof PhraseSegmentItem) {
                    this.marshalPhrase((PhraseSegmentItem)root, s);
                    break;
                }
                this.marshalPhrase((PhraseItem)root, s);
                break;
            }
            case NEAR: {
                this.marshalNear((NearItem)root, s);
                break;
            }
            case ONEAR: {
                this.marshalNear((ONearItem)root, s);
                break;
            }
            case WEAK_AND: {
                this.marshalWeakAnd((WeakAndItem)root, s);
                break;
            }
        }
    }

    private void marshalWord(TermItem item, StringBuilder s) {
        String index = item.getIndexName();
        if (index.length() != 0) {
            s.append(item.getIndexName()).append(':');
        }
        s.append(item.stringValue());
        if (item.getWeight() != 100) {
            s.append("!").append(item.getWeight());
        }
    }

    private void marshalRank(RankItem root, StringBuilder s) {
        this.marshalComposite("RANK", root, s);
    }

    private void marshalNot(NotItem root, StringBuilder s) {
        this.marshalComposite("ANDNOT", root, s);
    }

    private void marshalOr(OrItem root, StringBuilder s) {
        this.marshalComposite("OR", root, s);
    }

    private void dumpWords(CompositeItem root, StringBuilder s) {
        ListIterator<Item> i = root.getItemIterator();
        while (i.hasNext()) {
            Item word = (Item)i.next();
            boolean useSeparator = true;
            if (word instanceof TermItem) {
                s.append(((TermItem)word).stringValue());
                if (word instanceof WordItem) {
                    useSeparator = !((WordItem)word).isFromSegmented();
                }
            } else {
                this.dumpWords((CompositeItem)word, s);
            }
            if (!useSeparator || !i.hasNext()) continue;
            s.append(' ');
        }
    }

    private void marshalPhrase(PhraseItem root, StringBuilder s) {
        this.marshalPhrase(root, s, root.isExplicit(), false);
    }

    private void marshalPhrase(PhraseSegmentItem root, StringBuilder s) {
        this.marshalPhrase(root, s, root.isExplicit(), true);
    }

    private void marshalPhrase(IndexedItem root, StringBuilder s, boolean isExplicit, boolean isSegmented) {
        String index = root.getIndexName();
        if (index.length() != 0) {
            s.append(root.getIndexName()).append(':');
        }
        if (isExplicit || !isSegmented) {
            s.append('\"');
        }
        this.dumpWords((CompositeItem)((Object)root), s);
        if (isExplicit || !isSegmented) {
            s.append('\"');
        }
    }

    private void marshalNear(NearItem root, StringBuilder s) {
        this.marshalComposite(root.getName() + "(" + root.getDistance() + ")", root, s);
    }

    private void marshalAnd(CompositeItem root, StringBuilder s) {
        this.marshalComposite("AND", root, s);
    }

    private void marshalWeakAnd(WeakAndItem root, StringBuilder s) {
        this.marshalComposite("WAND(" + root.getN() + ")", root, s);
    }

    private void marshalComposite(String operator, CompositeItem root, StringBuilder s) {
        boolean useParen;
        boolean bl = useParen = !this.atRoot;
        if (useParen) {
            s.append("( ");
        } else {
            this.atRoot = false;
        }
        ListIterator<Item> i = root.getItemIterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            this.marshal(item, s);
            if (!i.hasNext()) continue;
            s.append(' ').append(operator).append(' ');
        }
        if (useParen) {
            s.append(" )");
        }
    }
}

