/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.http;

import com.google.common.collect.ImmutableList;
import com.yahoo.component.ComponentId;
import com.yahoo.jdisc.http.CertificateStore;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cache.QrBinaryCacheConfig;
import com.yahoo.search.cache.QrBinaryCacheRegionConfig;
import com.yahoo.search.federation.FederationSearcher;
import com.yahoo.search.federation.http.Connection;
import com.yahoo.search.federation.http.HTTPParameters;
import com.yahoo.search.federation.http.HTTPSearcher;
import com.yahoo.search.federation.http.TimedHttpEntity;
import com.yahoo.search.federation.http.TimeoutException;
import com.yahoo.search.query.Properties;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.statistics.Counter;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;

public abstract class HTTPProviderSearcher
extends HTTPSearcher {
    private final Counter emptyResults;
    private final Value hitsPerQuery;
    private final Value responseLatency;
    private final Counter readTimeouts;
    private static final List<String> excludedSourceProperties = ImmutableList.of((Object)"offset", (Object)"hits", (Object)"provider");
    protected static final Logger log = Logger.getLogger(HTTPProviderSearcher.class.getName());
    protected String cacheName = null;

    public HTTPProviderSearcher(ComponentId id, List<Connection> connections, String path, Statistics statistics) {
        this(id, connections, new HTTPParameters(path), statistics);
    }

    public HTTPProviderSearcher(ComponentId id, List<Connection> connections, String path, Statistics statistics, CertificateStore certificateStore) {
        this(id, connections, new HTTPParameters(path), statistics, certificateStore);
    }

    public HTTPProviderSearcher(ComponentId id, List<Connection> connections, HTTPParameters parameters, Statistics statistics) {
        this(id, connections, parameters, statistics, (CertificateStore)new HTTPSearcher.ThrowingCertificateStore());
    }

    public HTTPProviderSearcher(ComponentId id, List<Connection> connections, HTTPParameters parameters, Statistics statistics, CertificateStore certificateStore) {
        super(id, connections, parameters, statistics, certificateStore);
        String suffix = "_" + this.getId().getName().replace('.', '_');
        this.hitsPerQuery = new Value("hits_per_query" + suffix, statistics, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setNameExtension(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)));
        this.responseLatency = new Value("latency_start" + suffix, statistics, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.emptyResults = new Counter("empty_results" + suffix, statistics, false);
        this.readTimeouts = new Counter("read_timeout_" + suffix, statistics, false);
    }

    @Deprecated
    protected void configureCache(QrBinaryCacheConfig cacheConfig, QrBinaryCacheRegionConfig regionConfig) {
    }

    public void unmarshal(InputStream stream, long contentLength, Result result) throws IOException {
        throw new UnsupportedOperationException("Unmarshal must be implemented by " + this);
    }

    public void unmarshal(HttpEntity entity, Result result) throws IOException {
        Query query = result.getQuery();
        long len = entity.getContentLength();
        if (query.getTraceLevel() >= 4) {
            query.trace("Received " + len + " bytes response in " + this, false, 4);
        }
        query.trace("Unmarshaling result.", false, 6);
        this.unmarshal(entity.getContent(), len, result);
        if (query.getTraceLevel() >= 2) {
            query.trace("Handled " + len + " bytes response in " + this, false, 2);
        }
    }

    protected void addNonExcludedSourceProperties(Query query, Map<String, String> queryMap) {
        Properties sourceProperties = FederationSearcher.getSourceProperties(query);
        if (sourceProperties != null) {
            for (Map.Entry entry : sourceProperties.listProperties("").entrySet()) {
                if (excludedSourceProperties.contains(entry.getKey())) continue;
                queryMap.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
    }

    protected Result inspectAndReturnFinalResult(Result result, Hit requestMeta, Exception e) {
        return result;
    }

    private Result statisticsBeforeInspection(Result result, Hit requestMeta, Exception e) {
        int hitCount = result.getConcreteHitCount();
        if (hitCount == 0) {
            this.emptyResults.increment();
        }
        this.hitsPerQuery.put((double)hitCount);
        if (requestMeta != null) {
            requestMeta.setField("hit_count", hitCount);
        }
        return this.inspectAndReturnFinalResult(result, requestMeta, e);
    }

    @Override
    protected void logResponseLatency(long latency) {
        this.responseLatency.put((double)latency);
    }

    @Override
    public Result search(Query query, Execution execution, Connection connection) {
        Hit requestMeta = this.createRequestMeta();
        Result result = new Result(query);
        result.hits().add(requestMeta);
        query.trace("Created request information hit", false, 9);
        try {
            URI uri = this.getURI(query, requestMeta, connection);
            if (query.getTraceLevel() >= 1) {
                query.trace("Fetching " + uri.toString(), false, 1);
            }
            long requestStartTime = System.currentTimeMillis();
            HttpEntity entity = this.getEntity(uri, requestMeta, query);
            return entity == null ? this.statisticsBeforeInspection(result, requestMeta, null) : this.consumeEntity(entity, query, result, requestMeta, requestStartTime);
        }
        catch (MalformedURLException | URISyntaxException e) {
            result.hits().addError(this.createMalformedUrlError(query, e));
            return this.statisticsBeforeInspection(result, requestMeta, e);
        }
        catch (TimeoutException e) {
            result.hits().addError(ErrorMessage.createTimeout("No time left for HTTP traffic in " + this + " for " + query + ": " + e.getMessage()));
            return this.statisticsBeforeInspection(result, requestMeta, e);
        }
        catch (IOException e) {
            result.hits().addError(ErrorMessage.createBackendCommunicationError("Error when trying to connect to HTTP backend in " + this + " for " + query + ": " + Exceptions.toMessageString((Throwable)e)));
            return this.statisticsBeforeInspection(result, requestMeta, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result consumeEntity(HttpEntity entity, Query query, Result result, Hit logHit, long requestStartTime) {
        try {
            this.unmarshal(new TimedHttpEntity(entity, query.getStartTime(), Math.max(1L, query.getTimeout() - 10L)), result);
            logHit.setField("latency_finish", System.currentTimeMillis() - requestStartTime);
            Result result2 = this.statisticsBeforeInspection(result, logHit, null);
            return result2;
        }
        catch (IOException e) {
            result.hits().addError(ErrorMessage.createBackendCommunicationError("Error when trying to consume input in " + this + ": " + Exceptions.toMessageString((Throwable)e)));
            Result result3 = this.statisticsBeforeInspection(result, logHit, e);
            return result3;
        }
        catch (TimeoutException e) {
            this.readTimeouts.increment();
            result.hits().addError(ErrorMessage.createTimeout("Timed out while reading/unmarshaling from backend in " + this + " for " + query + ": " + e.getMessage()));
            Result result4 = this.statisticsBeforeInspection(result, logHit, e);
            return result4;
        }
        finally {
            this.cleanupHttpEntity(entity);
        }
    }

    @Override
    public Map<String, String> getQueryMap(Query query) {
        Map<String, String> queryMap = super.getQueryMap(query);
        this.addNonExcludedSourceProperties(query, queryMap);
        return queryMap;
    }

    @Deprecated
    public abstract Map<String, String> getCacheKey(Query var1);
}

