/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.http;

import com.google.common.base.Preconditions;
import com.yahoo.search.federation.ProviderConfig;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public final class HTTPParameters {
    public static final String RETRIES = "com.yahoo.search.federation.http.retries";
    private boolean frozen = false;
    private String path = "/";
    private int connectionTimeout = 2000;
    private int readTimeout = 5000;
    private boolean persistentConnections = true;
    private boolean enableProxy = false;
    private String proxyHost = "localhost";
    private int proxyPort = 1080;
    private String method = "GET";
    private String schema = "http";
    private String inputEncoding = "utf-8";
    private String outputEncoding = "utf-8";
    private int maxTotalConnections = 10000;
    private int maxConnectionsPerRoute = 10000;
    private int socketBufferSizeBytes = -1;
    private int retries = 1;
    private int configuredReadTimeout = -1;
    private int configuredConnectionTimeout = -1;
    private int connectionPoolTimeout = -1;
    private String certificateProxy = null;
    private int certificatePort = 0;
    private String certificateApplicationId = null;
    private boolean certificateUseProxy = false;
    private long certificateTtl = 0L;
    private long certificateRetry = 0L;
    private ProviderConfig.PingOption.Enum pingOption = ProviderConfig.PingOption.NORMAL;
    private boolean followRedirects = true;

    public HTTPParameters() {
    }

    public HTTPParameters(String path) {
        this.setPath(path);
    }

    public HTTPParameters(ProviderConfig providerConfig) {
        this.configuredReadTimeout = (int)(providerConfig.readTimeout() * 1000.0);
        this.configuredConnectionTimeout = (int)(providerConfig.connectionTimeout() * 1000.0);
        this.connectionPoolTimeout = (int)(providerConfig.connectionPoolTimeout() * 1000.0);
        this.retries = providerConfig.retries();
        this.setPath(providerConfig.path());
        this.certificateUseProxy = providerConfig.yca().useProxy();
        if (this.certificateUseProxy) {
            this.certificateProxy = providerConfig.yca().host();
            this.certificatePort = providerConfig.yca().port();
        }
        this.certificateApplicationId = providerConfig.yca().applicationId();
        this.certificateTtl = (long)providerConfig.yca().ttl() * 1000L;
        this.certificateRetry = (long)providerConfig.yca().retry() * 1000L;
        this.followRedirects = providerConfig.followRedirects();
        this.pingOption = providerConfig.pingOption();
    }

    public final void setPath(String path) {
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
    }

    public ProviderConfig.PingOption.Enum getPingOption() {
        return this.pingOption;
    }

    public void setPingOption(ProviderConfig.PingOption.Enum pingOption) {
        Preconditions.checkNotNull((Object)((Object)pingOption));
        this.ensureNotFrozen();
        this.pingOption = pingOption;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.ensureNotFrozen();
        this.followRedirects = followRedirects;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.ensureNotFrozen();
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.ensureNotFrozen();
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setPersistentConnections(boolean persistentConnections) {
        this.ensureNotFrozen();
        this.persistentConnections = persistentConnections;
    }

    public boolean getPersistentConnections() {
        return this.persistentConnections;
    }

    public boolean getEnableProxy() {
        return this.enableProxy;
    }

    public void setEnableProxy(boolean enableProxy) {
        this.ensureNotFrozen();
        this.enableProxy = enableProxy;
    }

    public String getProxyType() {
        return "http";
    }

    public void setProxyHost(String proxyHost) {
        this.ensureNotFrozen();
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.ensureNotFrozen();
        this.proxyPort = proxyPort;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setMethod(String method) {
        this.ensureNotFrozen();
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setSchema(String schema) {
        this.ensureNotFrozen();
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setInputEncoding(String inputEncoding) {
        this.ensureNotFrozen();
        this.inputEncoding = inputEncoding;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.ensureNotFrozen();
        this.outputEncoding = outputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void freeze() {
        this.frozen = true;
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot modify frozen " + this);
        }
    }

    public HttpParams toHttpParams() {
        return this.toHttpParams(this.connectionTimeout, this.readTimeout);
    }

    public HttpParams toHttpParams(int connectionTimeout, int readTimeout) {
        BasicHttpParams params = new BasicHttpParams();
        if (this.configuredConnectionTimeout > 0) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.configuredConnectionTimeout);
        } else {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
        }
        if (this.configuredReadTimeout > 0) {
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.configuredReadTimeout);
        } else {
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
        }
        if (this.socketBufferSizeBytes > 0) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)this.socketBufferSizeBytes);
        }
        if (this.connectionPoolTimeout > 0) {
            ConnManagerParams.setTimeout((HttpParams)params, (long)this.connectionPoolTimeout);
        }
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)this.maxTotalConnections);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(this.maxConnectionsPerRoute));
        if (this.retries >= 0) {
            params.setIntParameter(RETRIES, this.retries);
        }
        params.setParameter("http.protocol.handle-redirects", (Object)this.followRedirects);
        return params;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.ensureNotFrozen();
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.ensureNotFrozen();
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public int getSocketBufferSizeBytes() {
        return this.socketBufferSizeBytes;
    }

    public void setSocketBufferSizeBytes(int socketBufferSizeBytes) {
        this.ensureNotFrozen();
        this.socketBufferSizeBytes = socketBufferSizeBytes;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.ensureNotFrozen();
        this.retries = retries;
    }

    public String getYcaProxy() {
        return this.certificateProxy;
    }

    public int getYcaPort() {
        return this.certificatePort;
    }

    public String getYcaApplicationId() {
        return this.certificateApplicationId;
    }

    public boolean getYcaUseProxy() {
        return this.certificateUseProxy;
    }

    public long getYcaTtl() {
        return this.certificateTtl;
    }

    public long getYcaRetry() {
        return this.certificateRetry;
    }
}

