/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.collections.Pair;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.container.util.Util;
import com.yahoo.errorhandling.Results;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.federation.FederationConfig;
import com.yahoo.search.federation.FederationResult;
import com.yahoo.search.federation.StrictContractsConfig;
import com.yahoo.search.federation.selection.FederationTarget;
import com.yahoo.search.federation.selection.TargetSelector;
import com.yahoo.search.federation.sourceref.SearchChainInvocationSpec;
import com.yahoo.search.federation.sourceref.SearchChainResolver;
import com.yahoo.search.federation.sourceref.SingleTarget;
import com.yahoo.search.federation.sourceref.SourceRefResolver;
import com.yahoo.search.federation.sourceref.SourcesTarget;
import com.yahoo.search.federation.sourceref.UnresolvedSearchChainException;
import com.yahoo.search.query.properties.QueryProperties;
import com.yahoo.search.query.properties.SubProperties;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.HitOrderer;
import com.yahoo.search.searchchain.AsyncExecution;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.ForkingSearcher;
import com.yahoo.search.searchchain.FutureResult;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

@Provides(value={"Federation"})
@After(value={"*"})
public class FederationSearcher
extends ForkingSearcher {
    public static final String FEDERATION = "Federation";
    private static final Logger log = Logger.getLogger(FederationSearcher.class.getName());
    public static final CompoundName SOURCENAME = new CompoundName("sourceName");
    public static final CompoundName PROVIDERNAME = new CompoundName("providerName");
    public static final String LOG_COUNT_PREFIX = "count_";
    private final SearchChainResolver searchChainResolver;
    private final StrictContractsConfig.PropagateSourceProperties.Enum propagateSourceProperties;
    private final SourceRefResolver sourceRefResolver;
    private final CopyOnWriteHashMap<CompoundKey, CompoundName> map = new CopyOnWriteHashMap();
    private final boolean strictSearchchain;
    private final TargetSelector<?> targetSelector;
    private final Clock clock = Clock.systemUTC();

    @Inject
    public FederationSearcher(FederationConfig config, StrictContractsConfig strict, ComponentRegistry<TargetSelector> targetSelectors) {
        this(FederationSearcher.createResolver(config), strict.searchchains(), strict.propagateSourceProperties(), FederationSearcher.resolveSelector(config.targetSelector(), targetSelectors));
    }

    private static TargetSelector resolveSelector(String selectorId, ComponentRegistry<TargetSelector> targetSelectors) {
        if (selectorId.isEmpty()) {
            return null;
        }
        return (TargetSelector)Preconditions.checkNotNull((Object)targetSelectors.getComponent(selectorId), (Object)("Missing target selector with id" + Util.quote((Object)selectorId)));
    }

    public FederationSearcher(ComponentId id, SearchChainResolver searchChainResolver) {
        this(searchChainResolver, false, StrictContractsConfig.PropagateSourceProperties.ALL, null);
    }

    private FederationSearcher(SearchChainResolver searchChainResolver, boolean strictSearchchain, StrictContractsConfig.PropagateSourceProperties.Enum propagateSourceProperties, TargetSelector targetSelector) {
        this.searchChainResolver = searchChainResolver;
        this.sourceRefResolver = new SourceRefResolver(searchChainResolver);
        this.strictSearchchain = strictSearchchain;
        this.propagateSourceProperties = propagateSourceProperties;
        this.targetSelector = targetSelector;
    }

    private static SearchChainResolver createResolver(FederationConfig config) {
        SearchChainResolver.Builder builder = new SearchChainResolver.Builder();
        for (FederationConfig.Target target : config.target()) {
            boolean isDefaultProviderForSource = true;
            for (FederationConfig.Target.SearchChain searchChain : target.searchChain()) {
                if (searchChain.providerId() == null || searchChain.providerId().isEmpty()) {
                    FederationSearcher.addSearchChain(builder, target, searchChain);
                    continue;
                }
                FederationSearcher.addSourceForProvider(builder, target, searchChain, isDefaultProviderForSource);
                isDefaultProviderForSource = false;
            }
            if (!target.useByDefault()) continue;
            builder.useTargetByDefault(target.id());
        }
        return builder.build();
    }

    private static void addSearchChain(SearchChainResolver.Builder builder, FederationConfig.Target target, FederationConfig.Target.SearchChain searchChain) {
        if (!target.id().equals(searchChain.searchChainId())) {
            throw new RuntimeException("Invalid federation config, " + target.id() + " != " + searchChain.searchChainId());
        }
        builder.addSearchChain(ComponentId.fromString((String)searchChain.searchChainId()), FederationSearcher.federationOptions(searchChain), searchChain.documentTypes());
    }

    private static void addSourceForProvider(SearchChainResolver.Builder builder, FederationConfig.Target target, FederationConfig.Target.SearchChain searchChain, boolean isDefaultProvider) {
        builder.addSourceForProvider(ComponentId.fromString((String)target.id()), ComponentId.fromString((String)searchChain.providerId()), ComponentId.fromString((String)searchChain.searchChainId()), isDefaultProvider, FederationSearcher.federationOptions(searchChain), searchChain.documentTypes());
    }

    private static FederationOptions federationOptions(FederationConfig.Target.SearchChain searchChain) {
        return new FederationOptions().setOptional(searchChain.optional()).setUseByDefault(searchChain.useByDefault()).setTimeoutInMilliseconds(searchChain.timeoutMillis()).setRequestTimeoutInMilliseconds(searchChain.requestTimeoutMillis());
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result mergedResults = execution.search(query);
        Results<SearchChainInvocationSpec, UnresolvedSearchChainException> targets = this.getTargets(query.getModel().getSources(), query.properties(), execution.context().getIndexFacts());
        this.warnIfUnresolvedSearchChains(targets.errors(), mergedResults.hits());
        Collection<SearchChainInvocationSpec> prunedTargets = this.pruneTargetsWithoutDocumentTypes(query.getModel().getRestrict(), targets.data());
        Results<Target, ErrorMessage> regularTargetHandlers = this.resolveSearchChains(prunedTargets, execution.searchChainRegistry());
        query.errors().addAll(regularTargetHandlers.errors());
        LinkedHashSet<Target> targetHandlers = new LinkedHashSet<Target>(regularTargetHandlers.data());
        targetHandlers.addAll(FederationSearcher.getAdditionalTargets(query, execution, this.targetSelector));
        this.traceTargets(query, targetHandlers);
        if (targetHandlers.isEmpty()) {
            return mergedResults;
        }
        if (targetHandlers.size() > 1) {
            this.search(query, execution, targetHandlers, mergedResults);
        } else if (this.shouldExecuteTargetLongerThanThread(query, (Target)targetHandlers.iterator().next())) {
            this.search(query, execution, targetHandlers, mergedResults);
        } else {
            this.search(query, execution, (Target)CollectionUtil.first(targetHandlers), mergedResults);
        }
        return mergedResults;
    }

    private void search(Query query, Execution execution, Target target, Result mergedResults) {
        Optional<Result> result = this.search(query, execution, target);
        if (result.isPresent()) {
            this.mergeResult(query, target, mergedResults, result.get());
        } else {
            FederationSearcher.addSearchChainTimedOutError(query, target.getId());
        }
    }

    private void search(Query query, Execution execution, Collection<Target> targets, Result mergedResults) {
        FederationResult results = this.search(query, execution, targets);
        results.waitForAll((int)query.getTimeLeft(), this.clock);
        HitOrderer s = null;
        for (FederationResult.TargetResult targetResult : results.all()) {
            if (!targetResult.successfullyCompleted()) {
                FederationSearcher.addSearchChainTimedOutError(query, targetResult.target.getId());
                continue;
            }
            if (s == null) {
                s = this.dirtyCopyIfModifiedOrderer(mergedResults.hits(), targetResult.getOrTimeoutError().hits().getOrderer());
            }
            this.mergeResult(query, targetResult.target, mergedResults, targetResult.getOrTimeoutError());
        }
    }

    private Optional<Result> search(Query query, Execution execution, Target target) {
        long timeout = target.federationOptions().getSearchChainExecutionTimeoutInMilliseconds(query.getTimeLeft());
        if (timeout <= 0L) {
            return Optional.empty();
        }
        Execution newExecution = new Execution(target.getChain(), execution.context());
        if (this.strictSearchchain) {
            query.resetTimeout();
            return Optional.of(newExecution.search(this.createFederationQuery(query, query, Window.from(query), timeout, target)));
        }
        return Optional.of(newExecution.search(this.cloneFederationQuery(query, Window.from(query), timeout, target)));
    }

    private FederationResult search(Query query, Execution execution, Collection<Target> targets) {
        FederationResult.Builder result = new FederationResult.Builder();
        for (Target target : targets) {
            result.add(target, this.searchAsynchronously(query, execution, Window.from(targets, query), target));
        }
        return result.build();
    }

    private FutureResult searchAsynchronously(Query query, Execution execution, Window window, Target target) {
        long timeout = target.federationOptions().getSearchChainExecutionTimeoutInMilliseconds(query.getTimeLeft());
        if (timeout <= 0L) {
            return new FutureResult(() -> new Result(query, ErrorMessage.createTimeout("Timed out before federation")), execution, query);
        }
        Query clonedQuery = this.cloneFederationQuery(query, window, timeout, target);
        return new AsyncExecution(target.getChain(), execution).search(clonedQuery);
    }

    private Query cloneFederationQuery(Query query, Window window, long timeout, Target target) {
        Query clonedQuery = Query.createNewQuery(query);
        return this.createFederationQuery(query, clonedQuery, window, timeout, target);
    }

    private Query createFederationQuery(Query query, Query outgoing, Window window, long timeout, Target target) {
        ComponentId chainId = target.getChain().getId();
        String sourceName = chainId.getName();
        outgoing.properties().set(SOURCENAME, sourceName);
        String providerName = chainId.getName();
        if (chainId.getNamespace() != null) {
            providerName = chainId.getNamespace().getName();
        }
        outgoing.properties().set(PROVIDERNAME, providerName);
        outgoing.setTimeout(timeout);
        switch (this.propagateSourceProperties) {
            case ALL: {
                this.propagatePerSourceQueryProperties(query, outgoing, window, sourceName, providerName, QueryProperties.PER_SOURCE_QUERY_PROPERTIES);
                break;
            }
            case OFFSET_HITS: {
                this.propagatePerSourceQueryProperties(query, outgoing, window, sourceName, providerName, new CompoundName[]{Query.OFFSET, Query.HITS});
            }
        }
        target.modifyTargetQuery(outgoing);
        return outgoing;
    }

    private void propagatePerSourceQueryProperties(Query original, Query outgoing, Window window, String sourceName, String providerName, CompoundName[] queryProperties) {
        for (CompoundName key : queryProperties) {
            Object value = this.getSourceOrProviderProperty(original, key, sourceName, providerName, window.get(key));
            if (value == null) continue;
            outgoing.properties().set(key, value);
        }
    }

    private Object getSourceOrProviderProperty(Query query, CompoundName propertyName, String sourceName, String providerName, Object defaultValue) {
        Object result = this.getProperty(query, new SourceKey(sourceName, propertyName.toString()));
        if (result == null) {
            result = this.getProperty(query, new ProviderKey(providerName, propertyName.toString()));
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private Object getProperty(Query query, CompoundKey key) {
        CompoundName name = (CompoundName)this.map.get((Object)key);
        if (name == null) {
            name = new CompoundName(key.toString());
            this.map.put((Object)key, (Object)name);
        }
        return query.properties().get(name);
    }

    private ErrorMessage missingSearchChainsErrorMessage(List<UnresolvedSearchChainException> unresolvedSearchChainExceptions) {
        String message = StringUtils.join(this.getMessagesSet(unresolvedSearchChainExceptions), (char)' ') + " Valid source refs are " + StringUtils.join(this.allSourceRefDescriptions().iterator(), (String)", ") + '.';
        return ErrorMessage.createInvalidQueryParameter(message);
    }

    private List<String> allSourceRefDescriptions() {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (com.yahoo.search.federation.sourceref.Target target : this.searchChainResolver.allTopLevelTargets()) {
            descriptions.add(target.searchRefDescription());
        }
        return descriptions;
    }

    private Set<String> getMessagesSet(List<UnresolvedSearchChainException> unresolvedSearchChainExceptions) {
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        for (UnresolvedSearchChainException exception : unresolvedSearchChainExceptions) {
            messages.add(exception.getMessage());
        }
        return messages;
    }

    private void warnIfUnresolvedSearchChains(List<UnresolvedSearchChainException> missingTargets, HitGroup errorHitGroup) {
        if (!missingTargets.isEmpty()) {
            errorHitGroup.addError(this.missingSearchChainsErrorMessage(missingTargets));
        }
    }

    @Override
    public Collection<ForkingSearcher.CommentedSearchChain> getSearchChainsForwarded(SearchChainRegistry registry) {
        ArrayList<ForkingSearcher.CommentedSearchChain> searchChains = new ArrayList<ForkingSearcher.CommentedSearchChain>();
        for (com.yahoo.search.federation.sourceref.Target target : this.searchChainResolver.allTopLevelTargets()) {
            if (target instanceof SourcesTarget) {
                searchChains.addAll(this.commentedSourceProviderSearchChains((SourcesTarget)target, registry));
                continue;
            }
            if (target instanceof SingleTarget) {
                searchChains.add(this.commentedSearchChain((SingleTarget)target, registry));
                continue;
            }
            log.warning("Invalid target type " + ((Object)((Object)target)).getClass().getName());
        }
        return searchChains;
    }

    private ForkingSearcher.CommentedSearchChain commentedSearchChain(SingleTarget singleTarget, SearchChainRegistry registry) {
        return new ForkingSearcher.CommentedSearchChain("If source refs contains '" + singleTarget.getId() + "'.", registry.getChain(singleTarget.getId()));
    }

    private List<ForkingSearcher.CommentedSearchChain> commentedSourceProviderSearchChains(SourcesTarget sourcesTarget, SearchChainRegistry registry) {
        ArrayList<ForkingSearcher.CommentedSearchChain> commentedSearchChains = new ArrayList<ForkingSearcher.CommentedSearchChain>();
        String ifMatchingSourceRefPrefix = "If source refs contains '" + sourcesTarget.getId() + "' and provider is '";
        commentedSearchChains.add(new ForkingSearcher.CommentedSearchChain(ifMatchingSourceRefPrefix + sourcesTarget.defaultProviderSource().provider + "'(or not given).", registry.getChain(sourcesTarget.defaultProviderSource().searchChainId)));
        for (SearchChainInvocationSpec providerSource : sourcesTarget.allProviderSources()) {
            if (providerSource.equals(sourcesTarget.defaultProviderSource())) continue;
            commentedSearchChains.add(new ForkingSearcher.CommentedSearchChain(ifMatchingSourceRefPrefix + providerSource.provider + "'.", registry.getChain(providerSource.searchChainId)));
        }
        return commentedSearchChains;
    }

    public static com.yahoo.search.query.Properties getSourceProperties(Query query) {
        String sourceName = query.properties().getString(SOURCENAME);
        String providerName = query.properties().getString(PROVIDERNAME);
        if (sourceName == null || providerName == null) {
            return null;
        }
        SubProperties sourceProperties = new SubProperties("source." + sourceName, (Properties)query.properties());
        SubProperties providerProperties = new SubProperties("provider." + providerName, (Properties)query.properties());
        sourceProperties.chain(providerProperties);
        return sourceProperties;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        UniqueExecutionsToResults uniqueExecutionsToResults = new UniqueExecutionsToResults();
        this.addResultsToFill(result.hits(), result, summaryClass, uniqueExecutionsToResults);
        Set<Map.Entry<Chain<Searcher>, Map<Query, Result>>> resultsForAllChains = uniqueExecutionsToResults.resultsToFill.entrySet();
        int numberOfCallsToFillNeeded = 0;
        for (Map.Entry<Chain<Searcher>, Map<Query, Result>> resultsToFillForAChain : resultsForAllChains) {
            numberOfCallsToFillNeeded += resultsToFillForAChain.getValue().size();
        }
        ArrayList<Pair> futureFilledResults = new ArrayList<Pair>();
        for (Map.Entry<Chain<Searcher>, Map<Query, Result>> resultsToFillForAChain : resultsForAllChains) {
            Chain<Searcher> chain = resultsToFillForAChain.getKey();
            Execution chainExecution = chain == null ? execution : new Execution(chain, execution.context());
            for (Map.Entry<Query, Result> resultsToFillForAChainAndQuery : resultsToFillForAChain.getValue().entrySet()) {
                Result resultToFill = resultsToFillForAChainAndQuery.getValue();
                if (numberOfCallsToFillNeeded == 1) {
                    chainExecution.fill(resultToFill, summaryClass);
                    this.propagateErrors(resultToFill, result);
                    continue;
                }
                AsyncExecution asyncFill = new AsyncExecution(chainExecution);
                futureFilledResults.add(new Pair((Object)resultToFill, (Object)asyncFill.fill(resultToFill, summaryClass)));
            }
        }
        for (Pair futureFilledResult : futureFilledResults) {
            Optional<Result> filledResult = ((FutureResult)futureFilledResult.getSecond()).getIfAvailable(result.getQuery().getTimeLeft(), TimeUnit.MILLISECONDS);
            if (filledResult.isPresent()) {
                this.propagateErrors(filledResult.get(), result);
                continue;
            }
            result.hits().addError(((FutureResult)futureFilledResult.getSecond()).createTimeoutError());
            Iterator<Hit> i = ((Result)futureFilledResult.getFirst()).hits().unorderedDeepIterator();
            while (i.hasNext()) {
                Hit hit = result.hits().remove(i.next().getId());
            }
        }
    }

    private void propagateErrors(Result source, Result destination) {
        ErrorMessage error = source.hits().getError();
        if (error != null) {
            destination.hits().addError(error);
        }
    }

    private void addResultsToFill(HitGroup hitGroup, Result result, String summaryClass, UniqueExecutionsToResults uniqueExecutionsToResults) {
        for (Hit hit : hitGroup) {
            if (hit instanceof HitGroup) {
                this.addResultsToFill((HitGroup)hit, result, summaryClass, uniqueExecutionsToResults);
                continue;
            }
            if (hit.isFilled(summaryClass)) continue;
            this.getSearchChainGroup(hit, result, uniqueExecutionsToResults).hits().add(hit);
        }
    }

    private Result getSearchChainGroup(Hit hit, Result result, UniqueExecutionsToResults uniqueExecutionsToResults) {
        Chain chain = (Chain)hit.getSearcherSpecificMetaData(this);
        Query query = hit.getQuery() != null ? hit.getQuery() : result.getQuery();
        return uniqueExecutionsToResults.get((Chain<Searcher>)chain, query);
    }

    private HitOrderer dirtyCopyIfModifiedOrderer(HitGroup group, HitOrderer orderer) {
        HitOrderer old;
        if (!(orderer == null || (old = group.getOrderer()) != null && orderer.equals(old))) {
            group.setOrderer(orderer);
        }
        return orderer;
    }

    private Results<SearchChainInvocationSpec, UnresolvedSearchChainException> getTargets(Set<String> sources, com.yahoo.search.query.Properties properties, IndexFacts indexFacts) {
        return sources.isEmpty() ? this.defaultSearchChains(properties) : this.resolveSources(sources, properties, indexFacts);
    }

    private Results<SearchChainInvocationSpec, UnresolvedSearchChainException> resolveSources(Set<String> sources, com.yahoo.search.query.Properties properties, IndexFacts indexFacts) {
        Results.Builder result = new Results.Builder();
        for (String source : sources) {
            try {
                result.addAllData(this.sourceRefResolver.resolve(this.asSourceSpec(source), properties, indexFacts));
            }
            catch (UnresolvedSearchChainException e) {
                result.addError((Object)e);
            }
        }
        return result.build();
    }

    public Results<SearchChainInvocationSpec, UnresolvedSearchChainException> defaultSearchChains(com.yahoo.search.query.Properties sourceToProviderMap) {
        Results.Builder result = new Results.Builder();
        for (com.yahoo.search.federation.sourceref.Target target : this.searchChainResolver.defaultTargets()) {
            try {
                result.addData((Object)target.responsibleSearchChain(sourceToProviderMap));
            }
            catch (UnresolvedSearchChainException e) {
                result.addError((Object)e);
            }
        }
        return result.build();
    }

    private ComponentSpecification asSourceSpec(String source) {
        try {
            return new ComponentSpecification(source);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The source ref '" + source + "' used for federation is not valid.", e);
        }
    }

    private void traceTargets(Query query, Collection<Target> targets) {
        int traceFederationLevel = 2;
        if (!query.isTraceable(traceFederationLevel)) {
            return;
        }
        query.trace("Federating to " + targets, traceFederationLevel);
    }

    private boolean shouldExecuteTargetLongerThanThread(Query query, Target target) {
        return (long)target.federationOptions().getRequestTimeoutInMilliseconds() > query.getTimeout();
    }

    private static void addSearchChainTimedOutError(Query query, ComponentId searchChainId) {
        ErrorMessage timeoutMessage = ErrorMessage.createTimeout("The search chain '" + searchChainId + "' timed out.");
        timeoutMessage.setSource(searchChainId.stringValue());
        query.errors().add(timeoutMessage);
    }

    private void mergeResult(Query query, Target target, Result mergedResults, Result result) {
        target.modifyTargetResult(result);
        ComponentId searchChainId = target.getId();
        Chain<Searcher> searchChain = target.getChain();
        mergedResults.mergeWith(result);
        HitGroup group = result.hits();
        group.setId("source:" + searchChainId.getName());
        group.setSearcherSpecificMetaData(this, searchChain);
        group.setMeta(false);
        group.setAuxiliary(true);
        group.setSource(searchChainId.getName());
        group.setQuery(result.getQuery());
        Iterator<Hit> it = group.unorderedDeepIterator();
        while (it.hasNext()) {
            Hit hit = it.next();
            hit.setSearcherSpecificMetaData(this, searchChain);
            hit.setSource(searchChainId.stringValue());
            if (!hit.isMeta() || !hit.types().contains("logging")) continue;
            hit.setField("count_deep", result.getDeepHitCount());
            hit.setField("count_total", result.getTotalHitCount());
            int offset = result.getQuery().getOffset();
            hit.setField("count_first", offset + 1);
            hit.setField("count_last", result.getConcreteHitCount() + offset);
        }
        if (query.getTraceLevel() >= 4) {
            query.trace("Got " + group.getConcreteSize() + " hits from " + group.getId(), false, 4);
        }
        mergedResults.hits().add(group);
    }

    private Results<Target, ErrorMessage> resolveSearchChains(Collection<SearchChainInvocationSpec> prunedTargets, SearchChainRegistry registry) {
        Results.Builder targetHandlers = new Results.Builder();
        for (SearchChainInvocationSpec target : prunedTargets) {
            Chain<Searcher> chain = registry.getChain(target.searchChainId);
            if (chain == null) {
                targetHandlers.addError((Object)ErrorMessage.createIllegalQuery("Could not find search chain '" + target.searchChainId + "'"));
                continue;
            }
            targetHandlers.addData((Object)new StandardTarget(target, chain));
        }
        return targetHandlers.build();
    }

    private static <T> List<Target> getAdditionalTargets(Query query, Execution execution, TargetSelector<T> targetSelector) {
        if (targetSelector == null) {
            return Collections.emptyList();
        }
        ArrayList<Target> result = new ArrayList<Target>();
        for (FederationTarget<T> target : targetSelector.getTargets(query, execution.searchChainRegistry())) {
            result.add(new CustomTarget<T>(targetSelector, target));
        }
        return result;
    }

    private Collection<SearchChainInvocationSpec> pruneTargetsWithoutDocumentTypes(Set<String> restrict, List<SearchChainInvocationSpec> targets) {
        if (restrict.isEmpty()) {
            return targets;
        }
        ArrayList<SearchChainInvocationSpec> prunedTargets = new ArrayList<SearchChainInvocationSpec>();
        for (SearchChainInvocationSpec target : targets) {
            if (!target.documentTypes.isEmpty() && !this.documentTypeIntersectionIsNonEmpty(restrict, target)) continue;
            prunedTargets.add(target);
        }
        return prunedTargets;
    }

    private boolean documentTypeIntersectionIsNonEmpty(Set<String> restrict, SearchChainInvocationSpec target) {
        for (String documentType : target.documentTypes) {
            if (!restrict.contains(documentType)) continue;
            return true;
        }
        return false;
    }

    private static class Window {
        private final int hits;
        private final int offset;

        public Window(int hits, int offset) {
            this.hits = hits;
            this.offset = offset;
        }

        public Integer get(CompoundName parameterName) {
            if (parameterName.equals((Object)Query.HITS)) {
                return this.hits;
            }
            if (parameterName.equals((Object)Query.OFFSET)) {
                return this.offset;
            }
            return null;
        }

        public static Window from(Query query) {
            return new Window(query.getHits(), query.getOffset());
        }

        public static Window from(Collection<Target> targets, Query query) {
            if (targets.size() == 1) {
                return Window.from(query);
            }
            return new Window(query.getHits() + query.getOffset(), 0);
        }
    }

    private static class ProviderKey
    extends CompoundKey {
        public static final String PROVIDER = "provider.";

        ProviderKey(String sourceName, String propertyName) {
            super(sourceName, propertyName);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 0x11;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ProviderKey && super.equals(o);
        }

        @Override
        public String toString() {
            return PROVIDER + super.toString();
        }
    }

    private static class SourceKey
    extends CompoundKey {
        public static final String SOURCE = "source.";

        SourceKey(String sourceName, String propertyName) {
            super(sourceName, propertyName);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 7;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SourceKey && super.equals(o);
        }

        @Override
        public String toString() {
            return SOURCE + super.toString();
        }
    }

    private static class CompoundKey {
        private final String sourceName;
        private final String propertyName;

        CompoundKey(String sourceName, String propertyName) {
            this.sourceName = sourceName;
            this.propertyName = propertyName;
        }

        public int hashCode() {
            return this.sourceName.hashCode() ^ this.propertyName.hashCode();
        }

        public boolean equals(Object o) {
            CompoundKey rhs = (CompoundKey)o;
            return this.sourceName.equals(rhs.sourceName) && this.propertyName.equals(rhs.propertyName);
        }

        public String toString() {
            return this.sourceName + '.' + this.propertyName;
        }
    }

    private static class CustomTarget<T>
    extends Target {
        private final TargetSelector<T> selector;
        private final FederationTarget<T> target;

        CustomTarget(TargetSelector<T> selector, FederationTarget<T> target) {
            this.selector = selector;
            this.target = target;
        }

        @Override
        Chain<Searcher> getChain() {
            return this.target.getChain();
        }

        @Override
        public void modifyTargetQuery(Query query) {
            this.selector.modifyTargetQuery(this.target, query);
        }

        @Override
        public void modifyTargetResult(Result result) {
            this.selector.modifyTargetResult(this.target, result);
        }

        @Override
        public FederationOptions federationOptions() {
            return this.target.getFederationOptions();
        }
    }

    private static class StandardTarget
    extends Target {
        private final SearchChainInvocationSpec target;
        private final Chain<Searcher> chain;

        public StandardTarget(SearchChainInvocationSpec target, Chain<Searcher> chain) {
            this.target = target;
            this.chain = chain;
        }

        @Override
        Chain<Searcher> getChain() {
            return this.chain;
        }

        @Override
        void modifyTargetQuery(Query query) {
        }

        @Override
        void modifyTargetResult(Result result) {
        }

        @Override
        public FederationOptions federationOptions() {
            return this.target.federationOptions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StandardTarget)) {
                return false;
            }
            StandardTarget other = (StandardTarget)o;
            if (!Objects.equals(other.chain.getId(), this.chain.getId())) {
                return false;
            }
            return Objects.equals(other.target, this.target);
        }

        public int hashCode() {
            return Objects.hash(this.chain.getId(), this.target);
        }
    }

    static abstract class Target {
        Target() {
        }

        abstract Chain<Searcher> getChain();

        abstract void modifyTargetQuery(Query var1);

        abstract void modifyTargetResult(Result var1);

        ComponentId getId() {
            return this.getChain().getId();
        }

        public abstract FederationOptions federationOptions();

        public String toString() {
            return this.getChain().getId().stringValue();
        }
    }

    private static class UniqueExecutionsToResults {
        final Map<Chain<Searcher>, Map<Query, Result>> resultsToFill = new IdentityHashMap<Chain<Searcher>, Map<Query, Result>>();

        private UniqueExecutionsToResults() {
        }

        public Result get(Chain<Searcher> chain, Query query) {
            Result resultsToFillForAChainAndQuery;
            Map<Query, Result> resultsToFillForAChain = this.resultsToFill.get(chain);
            if (resultsToFillForAChain == null) {
                resultsToFillForAChain = new IdentityHashMap<Query, Result>();
                this.resultsToFill.put(chain, resultsToFillForAChain);
            }
            if ((resultsToFillForAChainAndQuery = resultsToFillForAChain.get(query)) == null) {
                resultsToFillForAChainAndQuery = new Result(query);
                resultsToFillForAChain.put(query, resultsToFillForAChainAndQuery);
            }
            return resultsToFillForAChainAndQuery;
        }
    }
}

