/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.debug;

import com.yahoo.container.Container;
import com.yahoo.jrt.Request;
import com.yahoo.prelude.cluster.ClusterSearcher;
import com.yahoo.protect.Validator;
import com.yahoo.search.Searcher;
import com.yahoo.search.handler.SearchHandler;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.search.searchchain.SearcherRegistry;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

final class SearcherUtils {
    SearcherUtils() {
    }

    private static Collection<Searcher> allSearchers() {
        SearchChainRegistry searchChainRegistry = SearcherUtils.getSearchHandler().getSearchChainRegistry();
        SearcherRegistry searcherRegistry = searchChainRegistry.getSearcherRegistry();
        return searcherRegistry.allComponents();
    }

    private static Collection<ClusterSearcher> allClusterSearchers() {
        return SearcherUtils.filter(SearcherUtils.allSearchers(), ClusterSearcher.class);
    }

    private static <T> Collection<T> filter(Collection<?> collection, Class<T> classToMatch) {
        ArrayList<T> filtered = new ArrayList<T>();
        for (Object candidate : collection) {
            if (!classToMatch.isInstance(candidate)) continue;
            filtered.add(classToMatch.cast(candidate));
        }
        return filtered;
    }

    public static Collection<ClusterSearcher> clusterSearchers(String clusterName) {
        Collection<ClusterSearcher> searchers = SearcherUtils.allClusterSearchers();
        CollectionUtils.filter(searchers, o -> clusterName.equalsIgnoreCase(((ClusterSearcher)((Object)((Object)o))).getClusterModelName()));
        return searchers;
    }

    static SearchHandler getSearchHandler() {
        SearchHandler searchHandler = (SearchHandler)((Object)Container.get().getRequestHandlerRegistry().getComponent("com.yahoo.search.handler.SearchHandler"));
        Validator.ensureNotNull((String)"The standard search handler is not available.", (Object)((Object)searchHandler));
        return searchHandler;
    }

    static Collection<ClusterSearcher> clusterSearchers(Request request) {
        String clusterName = request.parameters().get(0).asString();
        Collection<ClusterSearcher> searchers = SearcherUtils.clusterSearchers(clusterName);
        if (searchers.isEmpty()) {
            throw new RuntimeException("No cluster named " + clusterName);
        }
        return searchers;
    }
}

