/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.debug;

import com.yahoo.component.chain.Chain;
import com.yahoo.search.Searcher;
import com.yahoo.search.debug.IndentStringBuilder;
import com.yahoo.search.searchchain.ForkingSearcher;
import com.yahoo.search.searchchain.SearchChain;
import com.yahoo.search.searchchain.SearchChainRegistry;
import java.util.Collection;

public class SearchChainTextRepresentation {
    private final SearchChainRegistry searchChainRegistry;
    private final String textRepresentation;

    private void outputChain(IndentStringBuilder str, Chain<Searcher> chain) {
        if (chain == null) {
            str.append(" [Unresolved Searchchain]");
        } else {
            str.append(chain.getId()).append(" [Searchchain] ");
            Block block = new Block(str);
            for (Searcher searcher : chain.components()) {
                this.outputSearcher(str, searcher);
            }
            block.close();
        }
    }

    private void outputSearcher(IndentStringBuilder str, Searcher searcher) {
        str.append(searcher.getId()).append(" [Searcher]");
        if (!(searcher instanceof ForkingSearcher)) {
            str.newline();
            return;
        }
        Collection<ForkingSearcher.CommentedSearchChain> chains = ((ForkingSearcher)searcher).getSearchChainsForwarded(this.searchChainRegistry);
        if (chains.isEmpty()) {
            str.newline();
            return;
        }
        Block block = new Block(str);
        for (ForkingSearcher.CommentedSearchChain chain : chains) {
            if (chain.comment != null) {
                str.append(chain.comment).newline();
            }
            this.outputChain(str, chain.searchChain);
        }
        block.close();
    }

    public String toString() {
        return this.textRepresentation;
    }

    public SearchChainTextRepresentation(SearchChain searchChain, SearchChainRegistry searchChainRegistry) {
        this.searchChainRegistry = searchChainRegistry;
        IndentStringBuilder stringBuilder = new IndentStringBuilder();
        this.outputChain(stringBuilder, searchChain);
        this.textRepresentation = stringBuilder.toString();
    }

    private static class Block {
        private static final String openBlock = " {";
        private static final char closeBlock = '}';
        private final IndentStringBuilder str;
        private final int level;

        Block(IndentStringBuilder str) {
            this.str = str;
            this.level = str.append(openBlock).newlineAndIndent();
        }

        void close() {
            this.str.resetIndentLevel(this.level);
            this.str.append('}').newline();
        }
    }
}

