/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.debug;

import java.io.Serializable;

final class IndentStringBuilder
implements Serializable,
Appendable,
CharSequence {
    private final StringBuilder builder = new StringBuilder();
    private final String singleIndentation;
    private int level = 0;
    private boolean newline = true;

    private void appendIndentation() {
        if (this.newline) {
            for (int i = 0; i < this.level; ++i) {
                this.builder.append(this.singleIndentation);
            }
        }
        this.newline = false;
    }

    public IndentStringBuilder(String singleIndentation) {
        this.singleIndentation = singleIndentation;
    }

    public IndentStringBuilder() {
        this("  ");
    }

    public void resetIndentLevel(int level) {
        this.level = level;
    }

    public int newlineAndIndent() {
        this.newline();
        return this.indent();
    }

    public int indent() {
        return this.level++;
    }

    public IndentStringBuilder newline() {
        this.newline = true;
        this.builder.append('\n');
        return this;
    }

    public IndentStringBuilder append(Object o) {
        this.appendIndentation();
        this.builder.append(o);
        return this;
    }

    public IndentStringBuilder append(String s) {
        this.appendIndentation();
        this.builder.append(s);
        return this;
    }

    @Override
    public IndentStringBuilder append(CharSequence charSequence) {
        this.appendIndentation();
        this.builder.append(charSequence);
        return this;
    }

    @Override
    public IndentStringBuilder append(CharSequence charSequence, int i, int i1) {
        this.appendIndentation();
        this.builder.append(charSequence, i, i1);
        return this;
    }

    @Override
    public IndentStringBuilder append(char c) {
        this.appendIndentation();
        this.builder.append(c);
        return this;
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public char charAt(int i) {
        return this.builder.charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        return this.builder.subSequence(i, i1);
    }
}

