/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cluster;

import com.yahoo.search.cluster.BaseNodeMonitor;
import com.yahoo.search.cluster.MonitorConfiguration;
import com.yahoo.search.result.ErrorMessage;

public class TrafficNodeMonitor<T>
extends BaseNodeMonitor<T> {
    private boolean atStartUp = true;

    public TrafficNodeMonitor(T node, MonitorConfiguration configuration, boolean internal) {
        super(internal);
        this.node = node;
        this.configuration = configuration;
    }

    @Override
    public T getNode() {
        return (T)this.node;
    }

    @Override
    public void failed(ErrorMessage error) {
        this.respondedAt = this.now();
        switch (error.getCode()) {
            case 10: 
            case 11: {
                if (this.respondedAt - this.succeededAt <= 10000L) break;
                this.setWorking(false, "Not working for 10 s: " + error.toString());
                break;
            }
            default: {
                this.succeededAt = this.respondedAt;
            }
        }
    }

    @Override
    public void responded() {
        this.succeededAt = this.respondedAt = this.now();
        this.atStartUp = false;
        if (!this.isWorking) {
            this.setWorking(true, "Responds correctly");
        }
    }

    @Override
    protected synchronized void setWorking(boolean working, String explanation) {
        if (this.isWorking == working) {
            return;
        }
        explanation = explanation == null ? "" : ": " + explanation;
        if (working) {
            log.info("Putting " + this.node + " in service" + explanation);
        } else {
            if (!this.atStartUp || !this.isInternal()) {
                log.warning("Taking " + this.node + " out of service" + explanation);
            }
            this.failedAt = this.now();
        }
        this.isWorking = working;
    }
}

