/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cluster;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.search.cluster.BaseNodeMonitor;
import com.yahoo.search.cluster.MonitorConfiguration;
import com.yahoo.search.cluster.NodeManager;
import com.yahoo.search.cluster.TrafficNodeMonitor;
import com.yahoo.search.result.ErrorMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterMonitor<T> {
    private MonitorConfiguration configuration = new MonitorConfiguration();
    private static Logger log = Logger.getLogger(ClusterMonitor.class.getName());
    private NodeManager<T> nodeManager;
    private MonitorThread monitorThread;
    private volatile boolean shutdown = false;
    private final Map<T, BaseNodeMonitor<T>> nodeMonitors = Collections.synchronizedMap(new LinkedHashMap());

    @Deprecated
    public ClusterMonitor(NodeManager<T> manager, String ignored) {
        this(manager);
    }

    public ClusterMonitor(NodeManager<T> manager) {
        this.nodeManager = manager;
        this.monitorThread = new MonitorThread("search.clustermonitor");
        this.monitorThread.start();
    }

    public MonitorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void add(T node, boolean internal) {
        TrafficNodeMonitor<T> monitor = new TrafficNodeMonitor<T>(node, this.configuration, internal);
        this.nodeMonitors.put(node, monitor);
    }

    public BaseNodeMonitor<T> getNodeMonitor(T node) {
        return this.nodeMonitors.get(node);
    }

    public synchronized void failed(T node, ErrorMessage error) {
        BaseNodeMonitor<T> monitor = this.nodeMonitors.get(node);
        boolean wasWorking = monitor.isWorking();
        monitor.failed(error);
        if (wasWorking && !monitor.isWorking()) {
            this.nodeManager.failed(node);
        }
    }

    public synchronized void responded(T node) {
        BaseNodeMonitor<T> monitor = this.nodeMonitors.get(node);
        boolean wasFailing = !monitor.isWorking();
        monitor.responded();
        if (wasFailing && monitor.isWorking()) {
            this.nodeManager.working(monitor.getNode());
        }
    }

    public void ping(Executor executor) {
        Iterator<BaseNodeMonitor<T>> i = this.nodeMonitorIterator();
        while (i.hasNext()) {
            BaseNodeMonitor<T> monitor = i.next();
            this.nodeManager.ping(monitor.getNode(), executor);
        }
        this.nodeManager.pingIterationCompleted();
    }

    public Iterator<BaseNodeMonitor<T>> nodeMonitorIterator() {
        return this.nodeMonitors().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseNodeMonitor<T>> nodeMonitors() {
        Map<T, BaseNodeMonitor<T>> map = this.nodeMonitors;
        synchronized (map) {
            return new ArrayList<BaseNodeMonitor<T>>(this.nodeMonitors.values());
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.monitorThread.interrupt();
    }

    private class MonitorThread
    extends Thread {
        MonitorThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            log.fine("Starting cluster monitor thread");
            ExecutorService pingExecutor = Executors.newCachedThreadPool(ThreadFactoryFactory.getDaemonThreadFactory((String)"search.ping"));
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(ClusterMonitor.this.configuration.getCheckInterval());
                    log.finest("Activating ping");
                    ClusterMonitor.this.ping(pingExecutor);
                }
                catch (Exception e) {
                    if (ClusterMonitor.this.shutdown && e instanceof InterruptedException) break;
                    log.log(Level.WARNING, "Error in monitor thread", e);
                }
            }
            log.fine("Stopped cluster monitor thread");
        }
    }
}

