/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cache;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class QrBinaryCacheRegionConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "0f722e521a533247f88fafc934c97791";
    public static final String CONFIG_DEF_NAME = "qr-binary-cache-region";
    public static final String CONFIG_DEF_NAMESPACE = "search.cache";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.cache", "region_size int default=1024", "concurrency_level int default=50", "bucket_count int default=12000", "load_factor double default=0.75", "time_to_live int default=-1", "entry_size_range int default=500", "lazy_invalidation_enabled bool default=false", "tick_interval int default=1", "tick_count_to_average int default=10", "max_backend_qps int default=300", "lazy_invalidation_stats_file string default=\"lstats.log\"", "lazy_invalidation_max_stale_time_in_sec int default=1000"};
    private final IntegerNode region_size;
    private final IntegerNode concurrency_level;
    private final IntegerNode bucket_count;
    private final DoubleNode load_factor;
    private final IntegerNode time_to_live;
    private final IntegerNode entry_size_range;
    private final BooleanNode lazy_invalidation_enabled;
    private final IntegerNode tick_interval;
    private final IntegerNode tick_count_to_average;
    private final IntegerNode max_backend_qps;
    private final StringNode lazy_invalidation_stats_file;
    private final IntegerNode lazy_invalidation_max_stale_time_in_sec;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public QrBinaryCacheRegionConfig(Builder builder) {
        this(builder, true);
    }

    private QrBinaryCacheRegionConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for qr-binary-cache-region must be initialized: " + builder.__uninitialized);
        }
        this.region_size = builder.region_size == null ? new IntegerNode(1024) : new IntegerNode(builder.region_size.intValue());
        this.concurrency_level = builder.concurrency_level == null ? new IntegerNode(50) : new IntegerNode(builder.concurrency_level.intValue());
        this.bucket_count = builder.bucket_count == null ? new IntegerNode(12000) : new IntegerNode(builder.bucket_count.intValue());
        this.load_factor = builder.load_factor == null ? new DoubleNode(0.75) : new DoubleNode(builder.load_factor.doubleValue());
        this.time_to_live = builder.time_to_live == null ? new IntegerNode(-1) : new IntegerNode(builder.time_to_live.intValue());
        this.entry_size_range = builder.entry_size_range == null ? new IntegerNode(500) : new IntegerNode(builder.entry_size_range.intValue());
        this.lazy_invalidation_enabled = builder.lazy_invalidation_enabled == null ? new BooleanNode(false) : new BooleanNode(builder.lazy_invalidation_enabled.booleanValue());
        this.tick_interval = builder.tick_interval == null ? new IntegerNode(1) : new IntegerNode(builder.tick_interval.intValue());
        this.tick_count_to_average = builder.tick_count_to_average == null ? new IntegerNode(10) : new IntegerNode(builder.tick_count_to_average.intValue());
        this.max_backend_qps = builder.max_backend_qps == null ? new IntegerNode(300) : new IntegerNode(builder.max_backend_qps.intValue());
        this.lazy_invalidation_stats_file = builder.lazy_invalidation_stats_file == null ? new StringNode("lstats.log") : new StringNode(builder.lazy_invalidation_stats_file);
        this.lazy_invalidation_max_stale_time_in_sec = builder.lazy_invalidation_max_stale_time_in_sec == null ? new IntegerNode(1000) : new IntegerNode(builder.lazy_invalidation_max_stale_time_in_sec.intValue());
    }

    public int region_size() {
        return this.region_size.value();
    }

    public int concurrency_level() {
        return this.concurrency_level.value();
    }

    public int bucket_count() {
        return this.bucket_count.value();
    }

    public double load_factor() {
        return this.load_factor.value();
    }

    public int time_to_live() {
        return this.time_to_live.value();
    }

    public int entry_size_range() {
        return this.entry_size_range.value();
    }

    public boolean lazy_invalidation_enabled() {
        return this.lazy_invalidation_enabled.value();
    }

    public int tick_interval() {
        return this.tick_interval.value();
    }

    public int tick_count_to_average() {
        return this.tick_count_to_average.value();
    }

    public int max_backend_qps() {
        return this.max_backend_qps.value();
    }

    public String lazy_invalidation_stats_file() {
        return this.lazy_invalidation_stats_file.value();
    }

    public int lazy_invalidation_max_stale_time_in_sec() {
        return this.lazy_invalidation_max_stale_time_in_sec.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(QrBinaryCacheRegionConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer region_size = null;
        private Integer concurrency_level = null;
        private Integer bucket_count = null;
        private Double load_factor = null;
        private Integer time_to_live = null;
        private Integer entry_size_range = null;
        private Boolean lazy_invalidation_enabled = null;
        private Integer tick_interval = null;
        private Integer tick_count_to_average = null;
        private Integer max_backend_qps = null;
        private String lazy_invalidation_stats_file = null;
        private Integer lazy_invalidation_max_stale_time_in_sec = null;

        public Builder() {
        }

        public Builder(QrBinaryCacheRegionConfig config) {
            this.region_size(config.region_size());
            this.concurrency_level(config.concurrency_level());
            this.bucket_count(config.bucket_count());
            this.load_factor(config.load_factor());
            this.time_to_live(config.time_to_live());
            this.entry_size_range(config.entry_size_range());
            this.lazy_invalidation_enabled(config.lazy_invalidation_enabled());
            this.tick_interval(config.tick_interval());
            this.tick_count_to_average(config.tick_count_to_average());
            this.max_backend_qps(config.max_backend_qps());
            this.lazy_invalidation_stats_file(config.lazy_invalidation_stats_file());
            this.lazy_invalidation_max_stale_time_in_sec(config.lazy_invalidation_max_stale_time_in_sec());
        }

        private Builder override(Builder __superior) {
            if (__superior.region_size != null) {
                this.region_size(__superior.region_size);
            }
            if (__superior.concurrency_level != null) {
                this.concurrency_level(__superior.concurrency_level);
            }
            if (__superior.bucket_count != null) {
                this.bucket_count(__superior.bucket_count);
            }
            if (__superior.load_factor != null) {
                this.load_factor(__superior.load_factor);
            }
            if (__superior.time_to_live != null) {
                this.time_to_live(__superior.time_to_live);
            }
            if (__superior.entry_size_range != null) {
                this.entry_size_range(__superior.entry_size_range);
            }
            if (__superior.lazy_invalidation_enabled != null) {
                this.lazy_invalidation_enabled(__superior.lazy_invalidation_enabled);
            }
            if (__superior.tick_interval != null) {
                this.tick_interval(__superior.tick_interval);
            }
            if (__superior.tick_count_to_average != null) {
                this.tick_count_to_average(__superior.tick_count_to_average);
            }
            if (__superior.max_backend_qps != null) {
                this.max_backend_qps(__superior.max_backend_qps);
            }
            if (__superior.lazy_invalidation_stats_file != null) {
                this.lazy_invalidation_stats_file(__superior.lazy_invalidation_stats_file);
            }
            if (__superior.lazy_invalidation_max_stale_time_in_sec != null) {
                this.lazy_invalidation_max_stale_time_in_sec(__superior.lazy_invalidation_max_stale_time_in_sec);
            }
            return this;
        }

        public Builder region_size(int __value) {
            this.region_size = __value;
            return this;
        }

        private Builder region_size(String __value) {
            return this.region_size(Integer.valueOf(__value));
        }

        public Builder concurrency_level(int __value) {
            this.concurrency_level = __value;
            return this;
        }

        private Builder concurrency_level(String __value) {
            return this.concurrency_level(Integer.valueOf(__value));
        }

        public Builder bucket_count(int __value) {
            this.bucket_count = __value;
            return this;
        }

        private Builder bucket_count(String __value) {
            return this.bucket_count(Integer.valueOf(__value));
        }

        public Builder load_factor(double __value) {
            this.load_factor = __value;
            return this;
        }

        private Builder load_factor(String __value) {
            return this.load_factor(Double.valueOf(__value));
        }

        public Builder time_to_live(int __value) {
            this.time_to_live = __value;
            return this;
        }

        private Builder time_to_live(String __value) {
            return this.time_to_live(Integer.valueOf(__value));
        }

        public Builder entry_size_range(int __value) {
            this.entry_size_range = __value;
            return this;
        }

        private Builder entry_size_range(String __value) {
            return this.entry_size_range(Integer.valueOf(__value));
        }

        public Builder lazy_invalidation_enabled(boolean __value) {
            this.lazy_invalidation_enabled = __value;
            return this;
        }

        private Builder lazy_invalidation_enabled(String __value) {
            return this.lazy_invalidation_enabled(Boolean.valueOf(__value));
        }

        public Builder tick_interval(int __value) {
            this.tick_interval = __value;
            return this;
        }

        private Builder tick_interval(String __value) {
            return this.tick_interval(Integer.valueOf(__value));
        }

        public Builder tick_count_to_average(int __value) {
            this.tick_count_to_average = __value;
            return this;
        }

        private Builder tick_count_to_average(String __value) {
            return this.tick_count_to_average(Integer.valueOf(__value));
        }

        public Builder max_backend_qps(int __value) {
            this.max_backend_qps = __value;
            return this;
        }

        private Builder max_backend_qps(String __value) {
            return this.max_backend_qps(Integer.valueOf(__value));
        }

        public Builder lazy_invalidation_stats_file(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.lazy_invalidation_stats_file = __value;
            return this;
        }

        public Builder lazy_invalidation_max_stale_time_in_sec(int __value) {
            this.lazy_invalidation_max_stale_time_in_sec = __value;
            return this;
        }

        private Builder lazy_invalidation_max_stale_time_in_sec(String __value) {
            return this.lazy_invalidation_max_stale_time_in_sec(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return QrBinaryCacheRegionConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return QrBinaryCacheRegionConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return QrBinaryCacheRegionConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

