/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.templates;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class FormattingOptions {
    public static final String DEFAULT_TYPE_ATTRIBUTE_NAME = "type";
    private Map<String, String> fieldsAsAttributes = new LinkedHashMap<String, String>();
    private Map<String, SubtypeField> fieldsWithSubtypes = new LinkedHashMap<String, SubtypeField>();
    private Map<String, SubtypeFieldWithPrefix> prefixedFieldsWithSubtypes = new LinkedHashMap<String, SubtypeFieldWithPrefix>();
    private Set<String> fieldsNotRendered = new LinkedHashSet<String>();
    private Set<String> fieldsRendered = new LinkedHashSet<String>();

    public void formatFieldAsAttribute(String fieldName, String attributeName) {
        this.fieldsAsAttributes.put(fieldName, attributeName);
    }

    public Set<Map.Entry<String, String>> fieldsAsAttributes() {
        return Collections.unmodifiableSet(this.fieldsAsAttributes.entrySet());
    }

    public String getAttributeName(String fieldName) {
        return this.fieldsAsAttributes.get(fieldName);
    }

    public void formatFieldWithSubtype(String fieldName, String tagName, String typeAttributeName, String typeAttributeValue) {
        SubtypeField names = new SubtypeField();
        names.attributeName = typeAttributeName;
        names.attributeValue = typeAttributeValue;
        names.tagName = tagName;
        this.fieldsWithSubtypes.put(fieldName, names);
    }

    public SubtypeField getSubtype(String fieldName) {
        return this.fieldsWithSubtypes.get(fieldName);
    }

    public void formatFieldWithSubtype(String fieldNamePrefix, String tagName, String typeAttributeName) {
        SubtypeFieldWithPrefix names = new SubtypeFieldWithPrefix();
        names.attributeName = typeAttributeName;
        names.tagName = tagName;
        names.prefixLength = fieldNamePrefix.length();
        this.prefixedFieldsWithSubtypes.put(fieldNamePrefix, names);
    }

    public SubtypeFieldWithPrefix getSubtypeWithPrefix(String fieldName) {
        for (Map.Entry<String, SubtypeFieldWithPrefix> e : this.prefixedFieldsWithSubtypes.entrySet()) {
            if (!fieldName.startsWith(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    public boolean shouldRenderField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        if (fieldName.startsWith("$")) {
            return false;
        }
        if (!this.fieldsRendered.isEmpty()) {
            return this.fieldsRendered.contains(fieldName);
        }
        return !this.fieldsNotRendered.contains(fieldName);
    }

    public void setFieldToRender(String fieldName) {
        this.fieldsRendered.add(fieldName);
    }

    public void setFieldNotToRender(String fieldName) {
        this.fieldsNotRendered.add(fieldName);
    }

    static class SubtypeFieldWithPrefix
    extends SubtypeField {
        int prefixLength;

        SubtypeFieldWithPrefix() {
        }
    }

    static class SubtypeField {
        String tagName;
        String attributeName;
        String attributeValue;

        SubtypeField() {
        }
    }
}

