/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.config.search.AttributesConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Before(value={"backend"})
@After(value={"AccentRemoval"})
public class ValidateSortingSearcher
extends Searcher {
    private Map<String, AttributesConfig.Attribute> attributeNames = null;
    private String clusterName = "";
    private final QrSearchersConfig.Searchcluster.Indexingmode.Enum indexingMode;

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    private Map<String, AttributesConfig.Attribute> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(Map<String, AttributesConfig.Attribute> attributeNames) {
        this.attributeNames = attributeNames;
    }

    public void initAttributeNames(AttributesConfig config) {
        HashMap<String, AttributesConfig.Attribute> attributes = new HashMap<String, AttributesConfig.Attribute>(config.attribute().size());
        for (AttributesConfig.Attribute attr : config.attribute()) {
            if (AttributesConfig.Attribute.Collectiontype.SINGLE != attr.collectiontype()) continue;
            attributes.put(attr.name(), attr);
        }
        this.setAttributeNames(attributes);
    }

    public ValidateSortingSearcher(QrSearchersConfig qrsConfig, ClusterConfig clusterConfig, AttributesConfig attributesConfig) {
        this.initAttributeNames(attributesConfig);
        this.setClusterName(qrsConfig.searchcluster(clusterConfig.clusterId()).name());
        this.indexingMode = qrsConfig.searchcluster(clusterConfig.clusterId()).indexingmode();
    }

    @Override
    public Result search(Query query, Execution execution) {
        ErrorMessage e;
        if (this.indexingMode != QrSearchersConfig.Searchcluster.Indexingmode.STREAMING && (e = this.validate(query)) != null) {
            Result r = new Result(query);
            r.hits().addError(e);
            return r;
        }
        return execution.search(query);
    }

    private static Sorting.UcaSorter.Strength config2Strength(AttributesConfig.Attribute.Sortstrength.Enum s) {
        if (s == AttributesConfig.Attribute.Sortstrength.PRIMARY) {
            return Sorting.UcaSorter.Strength.PRIMARY;
        }
        if (s == AttributesConfig.Attribute.Sortstrength.SECONDARY) {
            return Sorting.UcaSorter.Strength.SECONDARY;
        }
        if (s == AttributesConfig.Attribute.Sortstrength.TERTIARY) {
            return Sorting.UcaSorter.Strength.TERTIARY;
        }
        if (s == AttributesConfig.Attribute.Sortstrength.QUATERNARY) {
            return Sorting.UcaSorter.Strength.QUATERNARY;
        }
        if (s == AttributesConfig.Attribute.Sortstrength.IDENTICAL) {
            return Sorting.UcaSorter.Strength.IDENTICAL;
        }
        return Sorting.UcaSorter.Strength.PRIMARY;
    }

    private ErrorMessage validate(Query query) {
        List<Sorting.FieldOrder> l;
        Sorting sorting = query.getRanking().getSorting();
        List<Sorting.FieldOrder> list = l = sorting != null ? sorting.fieldOrders() : null;
        if (l == null) {
            return null;
        }
        Map<String, AttributesConfig.Attribute> names = this.getAttributeNames();
        if (names == null) {
            return null;
        }
        String queryLocale = null;
        if (query.getModel().getLocale() != null) {
            queryLocale = query.getModel().getLocale().toString();
        }
        for (Sorting.FieldOrder f : l) {
            String name = f.getFieldName();
            if ("[rank]".equals(name) || "[docid]".equals(name)) continue;
            if (names.containsKey(name)) {
                AttributesConfig.Attribute attrConfig = names.get(name);
                if (attrConfig != null) {
                    if (f.getSortOrder() == Sorting.Order.UNDEFINED) {
                        f.setAscending(attrConfig.sortascending());
                    }
                    if (f.getSorter().getClass().equals(Sorting.AttributeSorter.class) && attrConfig.datatype() == AttributesConfig.Attribute.Datatype.STRING) {
                        if (attrConfig.sortfunction() == AttributesConfig.Attribute.Sortfunction.UCA) {
                            String locale = attrConfig.sortlocale();
                            if (locale == null || locale.isEmpty()) {
                                locale = queryLocale;
                            }
                            if (locale != null) {
                                f.setSorter(new Sorting.UcaSorter(name, locale, Sorting.UcaSorter.Strength.UNDEFINED));
                            } else {
                                f.setSorter(new Sorting.LowerCaseSorter(name));
                            }
                        } else if (attrConfig.sortfunction() == AttributesConfig.Attribute.Sortfunction.LOWERCASE) {
                            f.setSorter(new Sorting.LowerCaseSorter(name));
                        } else if (attrConfig.sortfunction() == AttributesConfig.Attribute.Sortfunction.RAW) {
                            f.setSorter(new Sorting.RawSorter(name));
                        } else {
                            f.setSorter(new Sorting.LowerCaseSorter(name));
                        }
                    }
                    if (!(f.getSorter() instanceof Sorting.UcaSorter)) continue;
                    Sorting.UcaSorter sorter = (Sorting.UcaSorter)f.getSorter();
                    String locale = sorter.getLocale();
                    if (locale == null || locale.isEmpty()) {
                        locale = attrConfig.sortlocale();
                    }
                    if (locale == null || locale.isEmpty()) {
                        locale = queryLocale;
                    }
                    if (locale == null || locale.isEmpty()) {
                        locale = "en_US";
                    }
                    Sorting.UcaSorter.Strength strength = sorter.getStrength();
                    if (sorter.getStrength() == Sorting.UcaSorter.Strength.UNDEFINED) {
                        strength = ValidateSortingSearcher.config2Strength(attrConfig.sortstrength());
                    }
                    if (sorter.getStrength() != Sorting.UcaSorter.Strength.UNDEFINED && sorter.getLocale() != null && !sorter.getLocale().isEmpty()) continue;
                    sorter.setLocale(locale, strength);
                    continue;
                }
                return ErrorMessage.createInvalidQueryParameter("The cluster " + this.getClusterName() + " has attribute config for field: " + name);
            }
            return ErrorMessage.createInvalidQueryParameter("The cluster " + this.getClusterName() + " has no sortable attribute named: " + name);
        }
        return null;
    }
}

