/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DocumentSourceSearcher
extends Searcher {
    private Result defaultFilledResult;
    private Map<Query, Result> completelyFilledResults = new HashMap<Query, Result>();
    private Map<Query, Result> attributeFilledResults = new HashMap<Query, Result>();
    private Map<Query, Result> unFilledResults = new HashMap<Query, Result>();
    long editionTimeStamp = 0L;
    private int queryCount;

    public DocumentSourceSearcher() {
        this.addDefaultResults();
    }

    public boolean addResultSet(Query query, Result fullResult) {
        Result emptyResult = new Result(query.clone());
        Result attributeResult = new Result(query.clone());
        emptyResult.setTotalHitCount(fullResult.getTotalHitCount());
        attributeResult.setTotalHitCount(fullResult.getTotalHitCount());
        int counter = 0;
        Iterator<Hit> i = fullResult.hits().deepIterator();
        while (i.hasNext()) {
            Hit fullHit = i.next();
            Hit emptyHit = fullHit.clone();
            emptyHit.clearFields();
            emptyHit.setFillable();
            emptyHit.setRelevance(fullHit.getRelevance());
            Hit attributeHit = fullHit.clone();
            this.removePropertiesNotStartingByA(attributeHit);
            attributeHit.setFillable();
            attributeHit.setRelevance(fullHit.getRelevance());
            for (String propertyKeyObject : fullHit.fields().keySet()) {
                String propertyKey = propertyKeyObject.toString();
                if (!propertyKey.startsWith("attribute")) continue;
                attributeHit.setField(propertyKey, fullHit.getField(propertyKey));
            }
            if (fullHit.getField("sddocname") != null) {
                attributeHit.setField("sddocname", fullHit.getField("sddocname"));
            }
            emptyHit.setField("summaryid", String.valueOf(counter));
            attributeHit.setField("summaryid", String.valueOf(counter));
            fullHit.setField("summaryid", String.valueOf(counter));
            ++counter;
            emptyResult.hits().add(emptyHit);
            attributeResult.hits().add(attributeHit);
        }
        this.unFilledResults.put(this.getQueryKeyClone(query), emptyResult);
        this.attributeFilledResults.put(this.getQueryKeyClone(query), attributeResult);
        if (this.completelyFilledResults.put(this.getQueryKeyClone(query), fullResult.clone()) != null) {
            this.setEditionTimeStamp(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    private Query getQueryKeyClone(Query query) {
        Query key = query.clone();
        key.setWindow(0, 0);
        key.getModel().setSources("");
        return key;
    }

    private void removePropertiesNotStartingByA(Hit hit) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : hit.fields().keySet()) {
            if (key.startsWith("a")) continue;
            toRemove.add(key);
        }
        for (String propertyName : toRemove) {
            hit.removeField(propertyName);
        }
    }

    private void addDefaultResults() {
        Query q = new Query("?query=default");
        Result r = new Result(q);
        r.hits().add(new Hit("http://default-1.html"));
        r.hits().add(new Hit("http://default-2.html"));
        r.hits().add(new Hit("http://default-3.html"));
        r.hits().add(new Hit("http://default-4.html"));
        this.defaultFilledResult = r;
        this.addResultSet(q, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEditionTimeStamp() {
        long myEditionTime;
        DocumentSourceSearcher documentSourceSearcher = this;
        synchronized (documentSourceSearcher) {
            myEditionTime = this.editionTimeStamp;
        }
        return myEditionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditionTimeStamp(long editionTime) {
        DocumentSourceSearcher documentSourceSearcher = this;
        synchronized (documentSourceSearcher) {
            this.editionTimeStamp = editionTime;
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        ++this.queryCount;
        Result r = this.unFilledResults.get(this.getQueryKeyClone(query));
        r = r == null ? this.defaultFilledResult.clone() : r.clone();
        r.setQuery(query);
        r.hits().trim(query.getOffset(), query.getHits());
        return r;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        Result filledResult = "attributeprefetch".equals(summaryClass) ? this.attributeFilledResults.get(this.getQueryKeyClone(result.getQuery())) : this.completelyFilledResults.get(this.getQueryKeyClone(result.getQuery()));
        if (filledResult == null) {
            filledResult = this.defaultFilledResult;
        }
        this.fillHits(filledResult, result, summaryClass);
    }

    private void fillHits(Result source, Result target, String summaryClass) {
        Iterator<Hit> hitsToFill = target.hits().deepIterator();
        while (hitsToFill.hasNext()) {
            Hit hitToFill = hitsToFill.next();
            String summaryId = (String)hitToFill.getField("summaryid");
            if (summaryId == null) continue;
            Hit filledHit = this.lookupBySummaryId(source, summaryId);
            if (filledHit == null) {
                throw new RuntimeException("Can't fill hit with summaryid '" + summaryId + "', not present");
            }
            Iterator<Map.Entry<String, Object>> props = filledHit.fieldIterator();
            while (props.hasNext()) {
                Map.Entry<String, Object> propertyEntry = props.next();
                hitToFill.setField(propertyEntry.getKey().toString(), propertyEntry.getValue());
            }
            hitToFill.setFilled(summaryClass);
        }
        target.analyzeHits();
    }

    private Hit lookupBySummaryId(Result result, String summaryId) {
        Iterator<Hit> i = result.hits().deepIterator();
        while (i.hasNext()) {
            Hit hit = i.next();
            if (!summaryId.equals(hit.getField("summaryid"))) continue;
            return hit;
        }
        return null;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void resetQueryCount() {
        this.queryCount = 0;
    }
}

