/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.fsa.FSA;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.TermItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PhraseMatcher {
    private FSA phraseFSA = null;
    private boolean matchPhraseItems = false;
    private boolean matchSingleItems = false;
    private boolean ignorePluralForm = false;
    private boolean matchAll = false;

    private PhraseMatcher() {
    }

    public PhraseMatcher(String phraseAutomatonFile) {
        this(phraseAutomatonFile, false);
    }

    public PhraseMatcher(String phraseAutomatonFile, boolean ignorePluralForm) {
        this.ignorePluralForm = ignorePluralForm;
        this.phraseFSA = new FSA(phraseAutomatonFile);
    }

    public PhraseMatcher(FSA phraseAutomatonFSA, boolean ignorePluralForm) {
        if (phraseAutomatonFSA == null) {
            throw new IllegalArgumentException("FSA is null");
        }
        this.ignorePluralForm = ignorePluralForm;
        this.phraseFSA = phraseAutomatonFSA;
    }

    public boolean isEmpty() {
        return this.phraseFSA == null;
    }

    public void setMatchPhraseItems(boolean matchPhraseItems) {
        this.matchPhraseItems = matchPhraseItems;
    }

    public void setMatchSingleItems(boolean matchSingleItems) {
        this.matchSingleItems = matchSingleItems;
    }

    public void setIgnorePluralForm(boolean ignorePluralForm) {
        this.ignorePluralForm = ignorePluralForm;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public List<Phrase> matchPhrases(Item queryItem) {
        if (this.matchSingleItems && queryItem instanceof TermItem) {
            return this.matchSingleItem((TermItem)queryItem);
        }
        MatchedPhrases phrases = new MatchedPhrases();
        this.recursivelyMatchPhrases(queryItem, phrases);
        return phrases.toList();
    }

    private List<Phrase> matchSingleItem(TermItem termItem) {
        String matchWord = LinguisticsCase.toLowerCase((String)termItem.stringValue());
        String replaceWord = null;
        FSA.State state = this.phraseFSA.getState();
        if (!this.matches(state, matchWord)) {
            if (!this.ignorePluralForm) {
                return null;
            }
            if (!this.matches(state, matchWord = this.switchForm(matchWord))) {
                return null;
            }
            replaceWord = matchWord;
        }
        ArrayList<Phrase> itemList = new ArrayList<Phrase>(1);
        itemList.add(new Phrase(termItem, replaceWord, state.dataString()));
        return itemList;
    }

    private boolean matches(FSA.State state, String word) {
        state.start();
        state.delta(word);
        return state.isFinal();
    }

    private void recursivelyMatchPhrases(Item item, MatchedPhrases phrases) {
        if (item == null) {
            return;
        }
        if (!(item instanceof CompositeItem)) {
            return;
        }
        if (!this.matchPhraseItems && item instanceof PhraseItem) {
            return;
        }
        CompositeItem owner = (CompositeItem)item;
        int i = 0;
        int checkItemCount = owner.getItemCount();
        if (owner instanceof NotItem) {
            checkItemCount = 1;
        }
        while (i < checkItemCount) {
            int largestFoundLength = this.findPhrasesAtStartpoint(i, owner, phrases);
            if (largestFoundLength == 0 || this.matchAll) {
                this.recursivelyMatchPhrases(owner.getItem(i), phrases);
                ++i;
                continue;
            }
            i += largestFoundLength;
        }
    }

    private int findPhrasesAtStartpoint(int startIndex, CompositeItem owner, MatchedPhrases phrases) {
        Item current;
        FSA.State state = this.phraseFSA.getState();
        Phrase phrase = null;
        List<String> replaceList = null;
        String index = null;
        state.start();
        for (int currentIndex = startIndex; currentIndex < owner.getItemCount() && (current = owner.getItem(currentIndex)) instanceof TermItem; ++currentIndex) {
            String invertedWord;
            TermItem termItem = (TermItem)current;
            if (state.isStartState()) {
                index = termItem.getIndexName();
            } else if (!termItem.getIndexName().equals(index)) break;
            String lowercased = LinguisticsCase.toLowerCase((String)termItem.stringValue());
            boolean matched = state.tryDeltaWord(lowercased);
            if (!matched && this.ignorePluralForm && (matched = state.tryDeltaWord(invertedWord = this.switchForm(lowercased)))) {
                replaceList = this.setReplace(replaceList, currentIndex - startIndex, invertedWord);
            }
            if (!matched) break;
            if (state.isFinal()) {
                phrase = new Phrase(owner, replaceList, startIndex, currentIndex - startIndex + 1, state.dataString());
            }
            if (!this.matchAll) continue;
            phrases.add(phrase);
        }
        if (phrase == null) {
            return 0;
        }
        if (!this.matchAll) {
            phrases.add(phrase);
        }
        return phrase.getLength();
    }

    private List<String> setReplace(List<String> replaceList, int index, String invertedWord) {
        if (replaceList == null) {
            replaceList = new ArrayList<String>();
        }
        while (replaceList.size() < index) {
            replaceList.add(null);
        }
        replaceList.add(invertedWord);
        return replaceList;
    }

    private String switchForm(String word) {
        if (word.endsWith("s") && word.length() > 2) {
            return word.substring(0, word.length() - 1);
        }
        return word + "s";
    }

    public static PhraseMatcher getNullMatcher() {
        return new PhraseMatcher(){

            @Override
            public List<Phrase> matchPhrases(Item item) {
                return null;
            }
        };
    }

    public static class Phrase {
        private Matched matched;
        private String data;

        private Phrase(Matched matched, String data) {
            this.matched = matched;
            this.data = data;
        }

        public Phrase(TermItem item, String replace, String data) {
            this(new MatchedWord(item, replace), data);
        }

        private Phrase(CompositeItem owner, List<String> replace, int startIndex, int length, String data) {
            this(new MatchedComposite(owner, replace, startIndex, length), data);
        }

        public CompositeItem getOwner() {
            return this.matched.getOwner();
        }

        public int getStartIndex() {
            return this.matched.getStartIndex();
        }

        public int getLength() {
            return this.matched.getLength();
        }

        public String getData() {
            return this.data;
        }

        public TermItem getItem(int index) {
            return this.matched.getItem(index);
        }

        public boolean isComplete() {
            return this.matched.isComplete();
        }

        public void replace() {
            this.matched.replace();
        }

        public void remove() {
            this.matched.remove();
        }

        public int getBackedLength() {
            return this.matched.getBackedLength();
        }

        public MatchIterator itemIterator() {
            return new MatchIterator(this);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("\"");
            MatchIterator i = this.itemIterator();
            while (i.hasNext()) {
                buffer.append(((Item)i.next()).toString());
                if (!i.hasNext()) continue;
                buffer.append(" ");
            }
            buffer.append("\"");
            return buffer.toString();
        }

        public static class MatchIterator
        implements Iterator<Item> {
            private Phrase phrase;
            private int currentIndex = 0;

            public MatchIterator(Phrase phrase) {
                this.phrase = phrase;
            }

            @Override
            public boolean hasNext() {
                return this.phrase.matched.hasItemAt(this.currentIndex);
            }

            public String getReplace() {
                return this.phrase.matched.getReplace(this.currentIndex - 1);
            }

            @Override
            public Item next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException(this + " has no more elements");
                }
                ++this.currentIndex;
                if (this.phrase.matched instanceof MatchedWord) {
                    return ((MatchedWord)this.phrase.matched).getItem();
                }
                return this.phrase.getOwner().getItem(this.phrase.getStartIndex() + this.currentIndex - 1);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove from a phrasematcher phrase");
            }
        }

        private static class MatchedComposite
        extends Matched {
            private CompositeItem owner;
            private int length;
            private int initialOwnerLength;
            private int startIndex;
            private Item startItem;
            private List<String> replace = null;

            public MatchedComposite(CompositeItem owner, List<String> replace, int startIndex, int length) {
                this.owner = owner;
                this.initialOwnerLength = owner.getItemCount();
                this.replace = replace;
                this.startIndex = startIndex;
                this.startItem = owner.getItem(startIndex);
                this.length = length;
            }

            @Override
            public CompositeItem getOwner() {
                return this.owner;
            }

            @Override
            public int getStartIndex() {
                return this.startIndex;
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            public int getBackedLength() {
                return this.owner.getItemCount() - this.startIndex;
            }

            @Override
            public boolean hasItemAt(int index) {
                this.adjustIfBackingChanged();
                if (this.startIndex < 0) {
                    return false;
                }
                if (index >= this.length) {
                    return false;
                }
                return index + this.startIndex < this.owner.getItemCount();
            }

            @Override
            public boolean isComplete() {
                return this.startIndex == 0 && this.length == this.owner.getItemCount();
            }

            @Override
            public TermItem getItem(int index) {
                this.adjustIfBackingChanged();
                return (TermItem)this.owner.getItem(this.startIndex + index);
            }

            @Override
            public String getReplace(int index) {
                if (this.replace == null) {
                    return null;
                }
                return this.replace.get(index);
            }

            @Override
            public void replace() {
                PhraseItem phrase = new PhraseItem();
                TermItem firstWord = (TermItem)this.owner.setItem(this.startIndex, phrase);
                this.replace(firstWord, 0);
                phrase.setIndexName(firstWord.getIndexName());
                phrase.addItem(firstWord);
                for (int i = 1; i < this.length; ++i) {
                    TermItem followingWord = (TermItem)this.owner.removeItem(this.startIndex + 1);
                    this.replace(followingWord, i);
                    phrase.addItem(followingWord);
                }
            }

            private void replace(TermItem item, int index) {
                if (this.replace == null) {
                    return;
                }
                String replaceString = this.replace.get(index);
                if (replaceString == null) {
                    return;
                }
                item.setValue(replaceString);
            }

            @Override
            public void remove() {
                for (int i = this.startIndex + this.length - 1; i >= this.startIndex; --i) {
                    this.owner.removeItem(i);
                }
            }

            @Override
            public boolean hasReplaces() {
                return this.replace != null;
            }

            private void adjustIfBackingChanged() {
                if (this.owner.getItemCount() == this.initialOwnerLength) {
                    return;
                }
                this.startIndex = this.owner.getItemIndex(this.startItem);
            }
        }

        private static class MatchedWord
        extends Matched {
            private TermItem item;
            private String replace;

            public MatchedWord(TermItem item, String replace) {
                this.item = item;
                this.replace = replace;
            }

            public Item getItem() {
                return this.item;
            }

            @Override
            public boolean hasItemAt(int index) {
                return index == 0;
            }

            @Override
            public CompositeItem getOwner() {
                return null;
            }

            @Override
            public int getStartIndex() {
                return 0;
            }

            @Override
            public int getLength() {
                return 1;
            }

            @Override
            public TermItem getItem(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("No word at " + index + " in " + this);
                }
                return this.item;
            }

            @Override
            public boolean isComplete() {
                return true;
            }

            @Override
            public int getBackedLength() {
                return 1;
            }

            @Override
            public String getReplace(int index) {
                return this.replace;
            }

            @Override
            public boolean hasReplaces() {
                return this.replace != null;
            }
        }

        private static abstract class Matched {
            private Matched() {
            }

            public abstract CompositeItem getOwner();

            public abstract int getStartIndex();

            public abstract int getLength();

            public abstract boolean isComplete();

            public abstract boolean hasItemAt(int var1);

            public void replace() {
            }

            public void remove() {
            }

            public abstract TermItem getItem(int var1);

            public abstract String getReplace(int var1);

            public abstract int getBackedLength();

            public abstract boolean hasReplaces();
        }
    }

    private static class MatchedPhrases {
        private List<Phrase> phrases = null;

        private MatchedPhrases() {
        }

        private void add(Phrase phrase) {
            if (phrase == null) {
                return;
            }
            if (this.phrases == null) {
                this.phrases = new ArrayList<Phrase>(5);
            }
            this.phrases.add(phrase);
        }

        public List<Phrase> toList() {
            return this.phrases;
        }
    }
}

