/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.textualrepresentation;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class TextualQueryRepresentation {
    private Map<Item, Integer> itemReferences = new IdentityHashMap<Item, Integer>();
    private int nextItemReference = 0;
    private final ItemDiscloser rootDiscloser;

    private String valueString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return '\"' + TextualQueryRepresentation.quote((String)value) + '\"';
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Enum) {
            return value.toString();
        }
        if (value instanceof Item) {
            return this.itemReference((Item)value);
        }
        if (value.getClass().isArray()) {
            return this.listString(this.arrayToList(value).iterator());
        }
        if (value instanceof List) {
            return this.listString(((List)value).iterator());
        }
        if (value instanceof Set) {
            return this.listString(((Set)value).iterator());
        }
        if (value instanceof Map) {
            return this.mapString((Map)value);
        }
        return '\"' + TextualQueryRepresentation.quote(value.toString()) + '\"';
    }

    private List arrayToList(Object array) {
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    private String mapString(Map<?, ?> map) {
        StringBuilder result = new StringBuilder();
        String mapBegin = "map(";
        result.append("map(");
        boolean firstTime = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!firstTime) {
                result.append(' ');
            }
            firstTime = false;
            result.append(this.valueString(entry.getKey())).append("=>").append(this.valueString(entry.getValue()));
        }
        result.append(')');
        return result.toString();
    }

    private String listString(Iterator<?> iterator) {
        StringBuilder result = new StringBuilder();
        result.append('(');
        boolean firstTime = true;
        while (iterator.hasNext()) {
            if (!firstTime) {
                result.append(' ');
            }
            firstTime = false;
            result.append(this.valueString(iterator.next()));
        }
        result.append(')');
        return result.toString();
    }

    private String itemReference(Item item) {
        Integer reference = this.itemReferences.get(item);
        return reference != null ? reference.toString() : "Unknown item: '" + System.identityHashCode(item) + "'";
    }

    private static String quote(String s) {
        return s.replaceAll("\"", "\\\\\"");
    }

    private ItemDiscloser expose(Item item) {
        ItemDiscloser itemDiscloser = new ItemDiscloser(item);
        item.disclose(itemDiscloser);
        return itemDiscloser;
    }

    public TextualQueryRepresentation(Item root) {
        this.rootDiscloser = this.expose(root);
    }

    public String toString() {
        return this.rootDiscloser.toString();
    }

    private class ItemDiscloser
    implements Discloser {
        private final Item item;
        final Map<String, Object> properties = new TreeMap<String, Object>();
        final String name;
        Object value;
        final List<ItemDiscloser> children = new ArrayList<ItemDiscloser>();

        ItemDiscloser(Item item) {
            this.item = item;
            this.name = item.getName();
        }

        @Override
        public void addProperty(String key, Object value) {
            assert (key.indexOf(32) == -1);
            this.properties.put(key, value);
            if (value instanceof Item) {
                this.setItemReference((Item)value);
            }
        }

        @Override
        public void setValue(Object value) {
            assert (this.children.isEmpty());
            this.value = value;
        }

        @Override
        public void addChild(Item child) {
            assert (this.value == null);
            this.children.add(TextualQueryRepresentation.this.expose(child));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name);
            if (!this.properties.isEmpty() || TextualQueryRepresentation.this.itemReferences.get(this.item) != null) {
                builder.append('[');
                this.addPropertiesString(builder);
                builder.append(']');
            }
            if (this.value != null || !this.children.isEmpty()) {
                builder.append("{\n");
                this.addBody(builder);
                builder.append("}\n");
            }
            return builder.toString();
        }

        private void addBody(StringBuilder builder) {
            if (this.value != null) {
                this.addIndented(builder, TextualQueryRepresentation.this.valueString(this.value));
            } else {
                for (ItemDiscloser child : this.children) {
                    this.addIndented(builder, child.toString());
                }
            }
        }

        private void addIndented(StringBuilder builder, String toAdd) {
            String indent = "  ";
            for (String line : toAdd.split(Pattern.quote("\n"))) {
                builder.append(indent).append(line).append('\n');
            }
        }

        private void addPropertiesString(StringBuilder s) {
            boolean firstTime = true;
            Integer itemReference = (Integer)TextualQueryRepresentation.this.itemReferences.get(this.item);
            if (itemReference != null) {
                this.addPropertyString(s, "%id", itemReference);
                firstTime = false;
            }
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                if (!firstTime) {
                    s.append(' ');
                }
                this.addPropertyString(s, entry.getKey(), entry.getValue());
                firstTime = false;
            }
        }

        private void addPropertyString(StringBuilder s, String key, Object value) {
            s.append(key).append('=').append(TextualQueryRepresentation.this.valueString(value));
        }

        private void setItemReference(Item item) {
            if (TextualQueryRepresentation.this.itemReferences.get(item) == null) {
                TextualQueryRepresentation.this.itemReferences.put(item, TextualQueryRepresentation.this.nextItemReference++);
            }
        }
    }
}

