/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.Limit;
import com.yahoo.prelude.query.RangeItem;
import com.yahoo.prelude.query.TermItem;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class IntItem
extends TermItem {
    private Limit from;
    private Limit to;
    private int hitLimit = 0;
    private String expression;

    public IntItem(int number, String indexName) {
        this(new Limit(number, true), new Limit(number, true), indexName);
    }

    public IntItem(long number, String indexName) {
        this(new Limit(number, true), new Limit(number, true), indexName);
    }

    public IntItem(Limit from, Limit to, String indexName) {
        super(indexName, false);
        this.from = from;
        this.to = to;
        this.expression = this.toExpression(from, to, 0);
    }

    private String toExpression(Limit from, Limit to, int hitLimit) {
        if (from.equals(to) && hitLimit == 0) {
            return from.number().toString();
        }
        String expression = from.toRangeStart() + ";" + to.toRangeEnd();
        if (hitLimit == 0) {
            return expression;
        }
        return expression.substring(0, expression.length() - 1) + ";" + hitLimit + expression.substring(expression.length() - 1);
    }

    public IntItem(String expression) {
        this(expression, "");
    }

    public IntItem(String expression, boolean isFromQuery) {
        this(expression, "", isFromQuery);
    }

    public IntItem(String expression, String indexName) {
        this(expression, indexName, false);
    }

    public IntItem(String expression, String indexName, boolean isFromQuery) {
        super(indexName, isFromQuery);
        this.setNumber(expression);
    }

    public IntItem(Limit from, Limit to, int hitLimit, String indexName, boolean isFromQuery) {
        super(indexName, isFromQuery);
        this.setLimits(from, to);
        this.hitLimit = hitLimit;
        this.expression = this.toExpression(from, to, hitLimit);
    }

    private final void setLimits(Limit from, Limit to) {
        if (from.number().doubleValue() > to.number().doubleValue()) {
            this.from = to;
            this.to = from;
        } else {
            this.from = from;
            this.to = to;
        }
    }

    public void setNumber(String expression) {
        try {
            this.expression = expression;
            this.parseAndAssignLimits(expression.trim());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("'" + expression + "' is not an int item expression: Expected NUMBER, '<'NUMBER, '>'NUMBER or ('['|'<')NUMBER;NUMBER(;NUMBER)?(']'|'>')", e);
        }
    }

    private void parseAndAssignLimits(String e) {
        if (e.startsWith("<") && !e.contains(";")) {
            this.from = Limit.NEGATIVE_INFINITY;
            this.to = new Limit(this.asNumber(e.substring(1)), false);
        } else if (e.startsWith(">")) {
            this.from = new Limit(this.asNumber(e.substring(1)), false);
            this.to = Limit.POSITIVE_INFINITY;
        } else if (e.startsWith("[") || e.startsWith("<")) {
            if (!e.endsWith("]") && !e.endsWith(">")) {
                throw new IllegalArgumentException("No closing bracket");
            }
            boolean inclusiveStart = e.startsWith("[");
            boolean inclusiveEnd = e.startsWith("[");
            String[] limits = e.substring(1, e.length() - 1).split(";");
            if (limits.length < 1 || limits.length > 3) {
                throw new IllegalArgumentException("Unexpected bracket content");
            }
            Limit from = new Limit(this.getOr(Double.NEGATIVE_INFINITY, 0, limits), inclusiveStart);
            Limit to = new Limit(this.getOr(Double.POSITIVE_INFINITY, 1, limits), inclusiveEnd);
            this.setLimits(from, to);
            this.hitLimit = this.getOr(0, 2, limits).intValue();
        } else {
            this.to = this.from = new Limit(this.asNumber(e), true);
        }
    }

    private Number getOr(Number defaultValue, int valueIndex, String[] values) {
        if (valueIndex >= values.length) {
            return defaultValue;
        }
        if (values[valueIndex] == null) {
            return defaultValue;
        }
        if (values[valueIndex].isEmpty()) {
            return defaultValue;
        }
        return this.asNumber(values[valueIndex]);
    }

    private Number asNumber(String numberString) {
        try {
            if (!numberString.contains(".")) {
                return new Long(numberString);
            }
        }
        catch (NumberFormatException e) {
            return new BigInteger(numberString);
        }
        return new Double(numberString);
    }

    public String getNumber() {
        return this.expression;
    }

    public final Limit getFromLimit() {
        return this.from;
    }

    public final Limit getToLimit() {
        return this.to;
    }

    public final int getHitLimit() {
        return this.hitLimit;
    }

    public final void setHitLimit(int hitLimit) {
        this.hitLimit = hitLimit;
        this.expression = this.toExpression(this.from, this.to, hitLimit);
    }

    @Override
    public String getRawWord() {
        return this.getNumber();
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.INT;
    }

    @Override
    public String getName() {
        return "INT";
    }

    @Override
    public String stringValue() {
        return this.expression;
    }

    @Override
    public void setValue(String value) {
        this.setNumber(value);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 199 * this.expression.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        IntItem other = (IntItem)object;
        if (!this.getFromLimit().equals(other.getFromLimit())) {
            return false;
        }
        if (!this.getToLimit().equals(other.getToLimit())) {
            return false;
        }
        return this.getHitLimit() == other.getHitLimit();
    }

    protected String getEncodedInt() {
        return this.getIndexedString();
    }

    @Override
    public String getIndexedString() {
        return this.expression;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntItem.putString(this.getEncodedInt(), buffer);
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public boolean isStemmed() {
        return true;
    }

    @Override
    public boolean isWords() {
        return false;
    }

    public static IntItem from(String indexName, Limit from, Limit to, int hitLimit) {
        if (hitLimit == 0 && (from.equals(Limit.NEGATIVE_INFINITY) || to.equals(Limit.POSITIVE_INFINITY) || from.equals(to))) {
            return new IntItem(from, to, indexName);
        }
        return new RangeItem(from, to, hitLimit, indexName, false);
    }
}

