/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.simple.Value;
import com.yahoo.io.SlowInflate;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.VariableLengthField;
import com.yahoo.prelude.hitfield.RawData;
import java.nio.ByteBuffer;

public class LongdataField
extends DocsumField
implements VariableLengthField {
    public LongdataField(String name) {
        super(name);
    }

    private Object convert(byte[] value) {
        return new RawData(value);
    }

    @Override
    public Object decode(ByteBuffer b) {
        boolean compressed;
        long dataLen = 0L;
        long len = (long)b.getInt() & 0xFFFFFFFFL;
        boolean bl = compressed = (len & Integer.MIN_VALUE) != 0L;
        if (compressed) {
            len &= Integer.MAX_VALUE;
            dataLen = b.getInt();
            len -= 4L;
        }
        byte[] tmp = new byte[(int)len];
        b.get(tmp);
        if (compressed) {
            SlowInflate inf = new SlowInflate();
            tmp = inf.unpack(tmp, (int)dataLen);
        }
        return this.convert(tmp);
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int len = b.getInt() & Integer.MAX_VALUE;
        b.position(offset + len + 4);
        return len + 4;
    }

    @Override
    public boolean isCompressed(ByteBuffer b) {
        int offset = b.position();
        int compressed = b.getInt() & Integer.MIN_VALUE;
        b.position(offset);
        return compressed != 0;
    }

    @Override
    public int sizeOfLength() {
        return 4;
    }

    @Override
    public Object convert(Inspector value) {
        return this.convert(value.asData(Value.empty().asData()));
    }
}

