/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.result.NanNumber;
import java.nio.ByteBuffer;

public class IntegerField
extends DocsumField {
    static final int EMPTY_VALUE = Integer.MIN_VALUE;

    public IntegerField(String name) {
        super(name);
    }

    private Object convert(int value) {
        if (value == Integer.MIN_VALUE) {
            return NanNumber.NaN;
        }
        return value;
    }

    @Override
    public Object decode(ByteBuffer b) {
        return this.convert(b.getInt());
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    public String toString() {
        return "field " + this.getName() + " type int";
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int bytelength = 4;
        b.position(offset + 4);
        return 4;
    }

    @Override
    public Object convert(Inspector value) {
        return this.convert((int)value.asLong(Integer.MIN_VALUE));
    }
}

