/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.container.util.Util;
import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.ChannelTimeoutException;
import com.yahoo.fs4.GetDocSumsPacket;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryPacket;
import com.yahoo.fs4.QueryResultPacket;
import com.yahoo.fs4.mplex.Backend;
import com.yahoo.fs4.mplex.FS4Channel;
import com.yahoo.fs4.mplex.InvalidChannelException;
import com.yahoo.net.HostName;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.CacheParams;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocsumPacketKey;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.PacketWrapper;
import com.yahoo.prelude.fastsearch.SummaryParameters;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.prelude.querytransform.QueryRewrite;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.dispatch.SearchCluster;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.searchchain.Execution;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;

public class FastSearcher
extends VespaBackEndSearcher {
    private static final CompoundName dispatchDirect = new CompoundName("dispatch.direct");
    private static final CompoundName dispatchCompression = new CompoundName("dispatch.compression");
    private final Dispatcher dispatcher;
    private final Backend dispatchBackend;
    private final FS4ResourcePool fs4ResourcePool;
    private final String selfHostname;

    public FastSearcher(Backend dispatchBackend, FS4ResourcePool fs4ResourcePool, Dispatcher dispatcher, SummaryParameters docSumParams, ClusterParams clusterParams, CacheParams cacheParams, DocumentdbInfoConfig documentdbInfoConfig) {
        this.init(docSumParams, clusterParams, cacheParams, documentdbInfoConfig);
        this.dispatchBackend = dispatchBackend;
        this.fs4ResourcePool = fs4ResourcePool;
        this.dispatcher = dispatcher;
        this.selfHostname = HostName.getLocalhost();
    }

    private int countFastHits(Result result) {
        int count = 0;
        Iterator<Hit> i = this.hitIterator(result);
        while (i.hasNext()) {
            if (!(i.next() instanceof FastHit)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Pong ping(Ping ping, Execution execution) {
        return FastSearcher.ping(ping, this.dispatchBackend, this.getName());
    }

    /*
     * Exception decompiling
     */
    public static Pong ping(Ping ping, Backend backend, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void transformQuery(Query query) {
        QueryRewrite.rewriteSddocname(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result doSearch2(Query query, QueryPacket queryPacket, CacheKey cacheKey, Execution execution) {
        try (FS4Channel channel = null;){
            if (this.dispatcher.searchCluster().groupSize() == 1) {
                this.forceSinglePassGrouping(query);
            }
            channel = this.chooseBackend(query).openChannel();
            channel.setQuery(query);
            Result result = this.searchTwoPhase(channel, query, queryPacket, cacheKey);
            if (query.properties().getBoolean(Ranking.RANKFEATURES, false)) {
                this.fill(result, query.getPresentation().getSummary(), execution);
            }
            Result result2 = result;
            return result2;
        }
    }

    private void forceSinglePassGrouping(Query query) {
        for (GroupingRequest groupingRequest : GroupingRequest.getRequests(query)) {
            this.forceSinglePassGrouping(groupingRequest.getRootOperation());
        }
    }

    private void forceSinglePassGrouping(GroupingOperation operation) {
        operation.setForceSinglePass(true);
        for (GroupingOperation childOperation : operation.getChildren()) {
            this.forceSinglePassGrouping(childOperation);
        }
    }

    private Backend chooseBackend(Query query) {
        if (!query.properties().getBoolean(dispatchDirect, false)) {
            return this.dispatchBackend;
        }
        if (!this.dispatchBackend.getHost().equals(this.selfHostname)) {
            return this.dispatchBackend;
        }
        Optional<SearchCluster.Node> directDispatchRecipient = this.dispatcher.searchCluster().directDispatchTarget();
        if (!directDispatchRecipient.isPresent()) {
            return this.dispatchBackend;
        }
        query.trace(false, 2, "Dispatching directly to ", directDispatchRecipient.get());
        return this.fs4ResourcePool.getBackend(directDispatchRecipient.get().hostname(), directDispatchRecipient.get().fs4port());
    }

    private void fillSDDocName(Result result) {
        DocumentDatabase db = this.getDocumentDatabase(result.getQuery());
        Iterator<Hit> i = this.hitIterator(result);
        while (i.hasNext()) {
            Hit hit = i.next();
            if (!(hit instanceof FastHit)) continue;
            hit.setField("sddocname", db.getName());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void doPartialFill(Result result, String summaryClass) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NonNull
    private static Optional<String> quotedSummaryClass(String summaryClass) {
        return Optional.of(summaryClass == null ? "[null]" : Util.quote((Object)summaryClass));
    }

    private CacheKey fetchCacheKeyFromHits(HitGroup hits, String summaryClass) {
        Iterator<Hit> i = hits.unorderedDeepIterator();
        while (i.hasNext()) {
            FastHit hit;
            Hit h = i.next();
            if (!(h instanceof FastHit) || (hit = (FastHit)h).isFilled(summaryClass) || hit.getCacheKey() == null) continue;
            return hit.getCacheKey();
        }
        return null;
    }

    private Result searchTwoPhase(FS4Channel channel, Query query, QueryPacket queryPacket, CacheKey cacheKey) throws IOException {
        BasicPacket[] basicPackets;
        if (this.isLoggingFine()) {
            this.getLogger().finest("sending query packet");
        }
        try {
            boolean couldSend = channel.sendPacket(queryPacket);
            if (!couldSend) {
                return new Result(query, ErrorMessage.createBackendCommunicationError("Could not reach '" + this.getName() + "'"));
            }
        }
        catch (InvalidChannelException e) {
            return new Result(query, ErrorMessage.createBackendCommunicationError("Invalid channel " + this.getName()));
        }
        catch (IllegalStateException e) {
            return new Result(query, ErrorMessage.createBackendCommunicationError("Illegal state in FS4: " + e.getMessage()));
        }
        try {
            basicPackets = channel.receivePackets(Math.max(50L, query.getTimeLeft()), 1);
        }
        catch (ChannelTimeoutException e) {
            return new Result(query, ErrorMessage.createTimeout("Timeout while waiting for " + this.getName()));
        }
        catch (InvalidChannelException e) {
            return new Result(query, ErrorMessage.createBackendCommunicationError("Invalid channel for " + this.getName()));
        }
        if (basicPackets.length == 0) {
            return new Result(query, ErrorMessage.createBackendCommunicationError(this.getName() + " got no packets back"));
        }
        if (this.isLoggingFine()) {
            this.getLogger().finest("got packets " + basicPackets.length + " packets");
        }
        FastSearcher.ensureInstanceOf(QueryResultPacket.class, basicPackets[0], this.getName());
        QueryResultPacket resultPacket = (QueryResultPacket)basicPackets[0];
        if (this.isLoggingFine()) {
            this.getLogger().finest("got query packet. docsumClass=" + query.getPresentation().getSummary());
        }
        if (query.getPresentation().getSummary() == null) {
            query.getPresentation().setSummary(this.getDefaultDocsumClass());
        }
        Result result = new Result(query);
        this.addMetaInfo(query, queryPacket.getQueryPacketData(), resultPacket, result, false);
        this.addUnfilledHits(result, resultPacket.getDocuments(), false, queryPacket.getQueryPacketData(), cacheKey);
        PacketWrapper packetWrapper = this.cacheControl.lookup(cacheKey, query);
        if (packetWrapper != null) {
            this.cacheControl.updateCacheEntry(cacheKey, query, resultPacket);
        } else if (!resultPacket.getCoverageFeature() || resultPacket.getCoverageFull()) {
            Packet[] packets = new Packet[]{resultPacket};
            this.cacheControl.cache(cacheKey, query, new DocsumPacketKey[0], packets);
        }
        return result;
    }

    private Packet[] convertBasicPackets(BasicPacket[] basicPackets) throws ClassCastException {
        Packet[] packets = new Packet[basicPackets.length];
        for (int i = 0; i < basicPackets.length; ++i) {
            packets[i] = (Packet)basicPackets[i];
        }
        return packets;
    }

    private Packet[] fetchSummaries(FS4Channel channel, Result result, String summaryClass) throws InvalidChannelException, ChannelTimeoutException, ClassCastException, IOException {
        boolean summaryNeedsQuery = this.summaryNeedsQuery(result.getQuery());
        if (result.getQuery().getTraceLevel() >= 3) {
            result.getQuery().trace((summaryNeedsQuery ? "Resending " : "Not resending ") + "query during document summary fetching", 3);
        }
        GetDocSumsPacket docsumsPacket = GetDocSumsPacket.create(result, summaryClass, summaryNeedsQuery);
        int compressionLimit = result.getQuery().properties().getInteger(PACKET_COMPRESSION_LIMIT, 0);
        docsumsPacket.setCompressionLimit(compressionLimit);
        if (compressionLimit != 0) {
            docsumsPacket.setCompressionType(result.getQuery().properties().getString(PACKET_COMPRESSION_TYPE, "lz4"));
        }
        boolean couldSend = channel.sendPacket(docsumsPacket);
        if (this.isLoggingFine()) {
            this.getLogger().finest("Sent " + docsumsPacket + " on " + channel);
        }
        if (!couldSend) {
            throw new IOException("Could not successfully send GetDocSumsPacket.");
        }
        BasicPacket[] receivedPackets = channel.receivePackets(Math.max(50L, result.getQuery().getTimeLeft()), docsumsPacket.getNumDocsums() + 1);
        if (this.isLoggingFine()) {
            this.getLogger().finest("got " + receivedPackets.length + "docsumPackets");
        }
        return this.convertBasicPackets(receivedPackets);
    }

    @Override
    public String toString() {
        return "fast searcher (" + this.getName() + ") " + this.dispatchBackend;
    }

    private DocsumPacketKey[] getPacketKeys(Result result, String summaryClass, boolean filled) {
        DocsumPacketKey[] packetKeys = new DocsumPacketKey[result.getHitCount()];
        int x = 0;
        Iterator<Hit> i = this.hitIterator(result);
        while (i.hasNext()) {
            Hit hit = i.next();
            if (!(hit instanceof FastHit)) continue;
            FastHit fastHit = (FastHit)hit;
            if (!filled && fastHit.isFilled(summaryClass)) continue;
            packetKeys[x] = new DocsumPacketKey(fastHit.getGlobalId(), fastHit.getPartId(), summaryClass);
            ++x;
        }
        if (x < packetKeys.length) {
            DocsumPacketKey[] tmp = new DocsumPacketKey[x];
            System.arraycopy(packetKeys, 0, tmp, 0, x);
            return tmp;
        }
        return packetKeys;
    }

    @Override
    protected boolean isLoggingFine() {
        return this.getLogger().isLoggable(Level.FINE);
    }
}

