/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.google.common.annotations.Beta;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.Value;
import com.yahoo.document.GlobalId;
import com.yahoo.fs4.QueryPacketData;
import com.yahoo.net.URI;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.Docsum;
import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.LongstringField;
import com.yahoo.prelude.fastsearch.StringField;
import com.yahoo.prelude.fastsearch.XMLField;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.Relevance;

public class FastHit
extends Hit {
    public static final String SUMMARY = "summary";
    private static final long serialVersionUID = 298098891191029589L;
    private GlobalId globalId = new GlobalId(new byte[12]);
    private int partId;
    private int distributionKey = 0;
    private URI indexUri = null;
    private int rowBits = 0;
    private boolean ignoreRowBits = false;
    private boolean useRowInIndexUri = true;
    private transient QueryPacketData queryPacketData = null;
    private transient CacheKey cacheKey = null;

    public FastHit() {
    }

    public FastHit(String uri, double relevancy) {
        this(uri, relevancy, (String)null);
    }

    public FastHit(String uri, double relevance, String source) {
        this.setId(uri);
        super.setField("uri", uri);
        this.setRelevance(new Relevance(relevance));
        this.setSource(source);
        this.types().add(SUMMARY);
        this.setPartId(0, 0);
    }

    @Override
    public String toString() {
        return super.toString() + " [fasthit, globalid: " + this.globalId + ", partId: " + this.partId + ", distributionkey: " + this.distributionKey + "]";
    }

    public static String asHexString(GlobalId gid) {
        byte[] rawGid;
        StringBuilder sb = new StringBuilder();
        for (byte b : rawGid = gid.getRawId()) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            throw new IllegalStateException("This hit must have a 'uri' field, and this fild must be filled through Execution.fill(Result)) before hashCode() is accessed.");
        }
        return super.hashCode();
    }

    @Override
    public URI getId() {
        return this.getUri();
    }

    public URI getUri() {
        URI uri = super.getId();
        if (uri != null) {
            return uri;
        }
        if (this.fields().containsKey("uri")) {
            Object o = this.getField("uri");
            this.setId(o.toString());
            return super.getId();
        }
        return this.getIndexUri();
    }

    public URI getIndexUri() {
        if (this.indexUri != null) {
            return this.indexUri;
        }
        String rowString = "-";
        if (this.useRowInIndexUri) {
            rowString = String.valueOf(this.getRow());
        }
        this.indexUri = new URI("index:" + this.getSourceNumber() + "/" + this.getColumn() + "/" + rowString + "/" + FastHit.asHexString(this.getGlobalId()));
        return this.indexUri;
    }

    public GlobalId getGlobalId() {
        return this.globalId;
    }

    public void setGlobalId(GlobalId globalId) {
        this.globalId = globalId;
    }

    public int getPartId() {
        return this.partId;
    }

    public void setPartId(int partId, int rowBits) {
        this.partId = partId;
        this.rowBits = rowBits;
    }

    public void setUseRowInIndexUri(boolean useRowInIndexUri) {
        this.useRowInIndexUri = useRowInIndexUri;
    }

    public int getColumn() {
        return this.partId >>> this.rowBits;
    }

    public int getRow() {
        if (this.rowBits == 0) {
            return 0;
        }
        return this.partId & (1 << this.rowBits) - 1;
    }

    @Override
    public Object getField(String key) {
        Object value = super.getField(key);
        if (value instanceof LazyValue) {
            return this.getAndCacheLazyValue(key, (LazyValue)value);
        }
        return value;
    }

    private Object getAndCacheLazyValue(String key, LazyValue value) {
        Object forcedValue = value.getValue(key);
        this.setField(key, forcedValue);
        return forcedValue;
    }

    @Override
    public boolean isMeta() {
        return false;
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    public void setDistributionKey(int distributionKey) {
        this.distributionKey = distributionKey;
    }

    public void addSummary(Docsum docsum) {
        LazyDocsumValue lazyDocsumValue = new LazyDocsumValue(docsum);
        this.reserve(docsum.getDefinition().getFieldCount());
        for (DocsumField field : docsum.getDefinition().getFields()) {
            this.setDocsumFieldIfNotPresent(field.getName(), lazyDocsumValue);
        }
    }

    void addSummary(DocsumDefinition docsumDef, Inspector value) {
        this.reserve(docsumDef.getFieldCount());
        for (DocsumField field : docsumDef.getFields()) {
            String fieldName = field.getName();
            if (value.type() == Type.STRING && (field instanceof LongstringField || field instanceof StringField || field instanceof XMLField)) {
                this.setDocsumFieldIfNotPresent(fieldName, new LazyString(field, value));
                continue;
            }
            Inspector f = value.field(fieldName);
            if (!field.getEmulConfig().forceFillEmptyFields() && !f.valid()) continue;
            this.setDocsumFieldIfNotPresent(fieldName, field.convert(f));
        }
    }

    private void setDocsumFieldIfNotPresent(String fieldName, Object value) {
        if (super.getField(fieldName) == null) {
            this.setField(fieldName, value);
        }
    }

    @Beta
    public void setLazyStringField(String fieldName, byte[] value) {
        this.setField(fieldName, new LazyString(new StringField(fieldName), (Inspector)new Value.StringValue(value)));
    }

    public void setQueryPacketData(QueryPacketData queryPacketData) {
        if (this.queryPacketData != null) {
            throw new IllegalStateException("Query packet data already set to " + this.queryPacketData + ", tried to set it to " + queryPacketData);
        }
        if (queryPacketData == null) {
            throw new NullPointerException("Query packet data reference can not be set to null.");
        }
        this.queryPacketData = queryPacketData;
    }

    public QueryPacketData getQueryPacketData() {
        return this.queryPacketData;
    }

    CacheKey getCacheKey() {
        return this.cacheKey;
    }

    void setCacheKey(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void setIgnoreRowBits(boolean ignoreRowBits) {
        this.ignoreRowBits = ignoreRowBits;
    }

    public boolean shouldIgnoreRowBits() {
        return this.ignoreRowBits;
    }

    public boolean fieldIsNotDecoded(String name) {
        return super.getField(name) instanceof LazyValue;
    }

    public RawField fetchFieldAsUtf8(String fieldName) {
        Object value = super.getField(fieldName);
        if (value instanceof LazyValue) {
            return ((LazyValue)value).getFieldAsUtf8(fieldName);
        }
        throw new IllegalStateException("Field " + fieldName + " has already been decoded:" + value);
    }

    private static class LazyString
    extends LazyValue {
        private final Inspector value;
        private final DocsumField fieldType;

        LazyString(DocsumField fieldType, Inspector value) {
            assert (value.type() == Type.STRING);
            this.value = value;
            this.fieldType = fieldType;
        }

        @Override
        Object getValue(String fieldName) {
            return this.value.asString();
        }

        @Override
        RawField getFieldAsUtf8(String fieldName) {
            return new RawField(this.fieldType, this.value.asUtf8());
        }
    }

    private static class LazyDocsumValue
    extends LazyValue {
        private final Docsum docsum;

        LazyDocsumValue(Docsum docsum) {
            this.docsum = docsum;
        }

        @Override
        Object getValue(String fieldName) {
            return this.docsum.decode(this.getFieldIndex(fieldName));
        }

        private int getFieldIndex(String fieldName) {
            Integer index = this.docsum.getFieldIndex(fieldName);
            if (index == null) {
                throw new AssertionError((Object)("Invalid fieldName " + fieldName));
            }
            return index;
        }

        @Override
        RawField getFieldAsUtf8(String fieldName) {
            return this.docsum.fetchFieldAsUtf8(this.getFieldIndex(fieldName));
        }
    }

    private static abstract class LazyValue {
        private LazyValue() {
        }

        abstract Object getValue(String var1);

        abstract RawField getFieldAsUtf8(String var1);
    }

    public static final class RawField {
        private final boolean needXmlEscape;
        private final byte[] contents;

        public RawField(DocsumField fieldType, byte[] contents) {
            this.needXmlEscape = !(fieldType instanceof XMLField);
            this.contents = contents;
        }

        public byte[] getUtf8() {
            return this.contents;
        }

        public boolean needXmlEscape() {
            return this.needXmlEscape;
        }
    }
}

