/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.google.common.collect.ImmutableMap;
import com.yahoo.container.search.LegacyEmulationConfig;
import com.yahoo.prelude.fastsearch.DocsumDefinitionSet;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.RankProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocumentDatabase {
    public static final String MATCH_PROPERTY = "match";
    public static final String SEARCH_DOC_TYPE_KEY = "documentdb.searchdoctype";
    private final String name;
    private final DocsumDefinitionSet docsumDefSet;
    private final Map<String, RankProfile> rankProfiles;

    public DocumentDatabase(DocumentdbInfoConfig.Documentdb documentDb, LegacyEmulationConfig emulConfig) {
        this.name = documentDb.name();
        this.docsumDefSet = new DocsumDefinitionSet(documentDb, emulConfig);
        this.rankProfiles = ImmutableMap.copyOf(this.toRankProfiles(documentDb.rankprofile()));
    }

    public String getName() {
        return this.name;
    }

    public DocsumDefinitionSet getDocsumDefinitionSet() {
        return this.docsumDefSet;
    }

    public Map<String, RankProfile> rankProfiles() {
        return this.rankProfiles;
    }

    private Map<String, RankProfile> toRankProfiles(List<DocumentdbInfoConfig.Documentdb.Rankprofile> rankProfileConfigList) {
        HashMap<String, RankProfile> rankProfiles = new HashMap<String, RankProfile>();
        for (DocumentdbInfoConfig.Documentdb.Rankprofile c : rankProfileConfigList) {
            rankProfiles.put(c.name(), new RankProfile(c.name(), c.hasSummaryFeatures(), c.hasRankFeatures()));
        }
        return rankProfiles;
    }
}

