/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.container.search.LegacyEmulationConfig;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.prelude.ConfigurationException;
import com.yahoo.prelude.fastsearch.Docsum;
import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class DocsumDefinitionSet {
    public static final int SLIME_MAGIC_ID = 0x55555555;
    private static final Logger log = Logger.getLogger(DocsumDefinitionSet.class.getName());
    private final HashMap<Long, DocsumDefinition> definitions = new HashMap();
    private final HashMap<String, DocsumDefinition> definitionsByName = new HashMap();
    private final LegacyEmulationConfig emulationConfig;

    public DocsumDefinitionSet(DocumentdbInfoConfig.Documentdb config) {
        this.emulationConfig = new LegacyEmulationConfig(new LegacyEmulationConfig.Builder());
        this.configure(config);
    }

    public DocsumDefinitionSet(DocumentdbInfoConfig.Documentdb config, LegacyEmulationConfig emulConfig) {
        this.emulationConfig = emulConfig;
        this.configure(config);
    }

    public final DocsumDefinition getDocsumDefinition(long id) {
        return this.definitions.get(new Long(id));
    }

    public final DocsumDefinition getDocsumDefinition(String name) {
        if (name == null) {
            name = "default";
        }
        return this.definitionsByName.get(name);
    }

    public final void lazyDecode(String summaryClass, byte[] data, FastHit hit) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long docsumClassId = buffer.getInt();
        if (docsumClassId != 0x55555555L) {
            log.warning("Only expecting SchemaLess docsums");
            DocsumDefinition docsumDefinition = this.lookupDocsum(docsumClassId);
            Docsum docsum = new Docsum(docsumDefinition, data);
            hit.addSummary(docsum);
        } else {
            DocsumDefinition docsumDefinition = this.lookupDocsum(summaryClass);
            Slime value = BinaryFormat.decode((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)buffer.remaining());
            hit.addSummary(docsumDefinition, (com.yahoo.data.access.Inspector)new SlimeAdapter((Inspector)value.get()));
        }
    }

    private DocsumDefinition lookupDocsum(long docsumClassId) {
        DocsumDefinition docsumDefinition = this.getDocsumDefinition(docsumClassId);
        if (docsumDefinition == null) {
            throw new ConfigurationException("Received hit with summary id " + docsumClassId + ", but this summary class is not in current summary config (" + this.toString() + ") (that is, the system is in an inconsistent state)");
        }
        return docsumDefinition;
    }

    private DocsumDefinition lookupDocsum(String summaryClass) {
        DocsumDefinition ds = this.definitionsByName.get(summaryClass);
        if (ds == null) {
            ds = this.definitionsByName.get("default");
        }
        if (ds == null) {
            throw new ConfigurationException("Fetched hit with summary class " + summaryClass + ", but this summary class is not in current summary config (" + this.toString() + ") (that is, you asked for something unknown, and no default was found)");
        }
        return ds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Long, DocsumDefinition>> entrySet = this.definitions.entrySet();
        boolean first = true;
        Iterator<Map.Entry<Long, DocsumDefinition>> itr = entrySet.iterator();
        while (itr.hasNext()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            Map.Entry<Long, DocsumDefinition> entry = itr.next();
            sb.append("[").append(entry.getKey()).append(",").append(entry.getValue().getName()).append("]");
        }
        return sb.toString();
    }

    public int size() {
        return this.definitions.size();
    }

    private void configure(DocumentdbInfoConfig.Documentdb config) {
        for (int i = 0; i < config.summaryclass().size(); ++i) {
            DocumentdbInfoConfig.Documentdb.Summaryclass sc = config.summaryclass(i);
            DocsumDefinition docSumDef = new DocsumDefinition(sc, this.emulationConfig);
            this.definitions.put(Long.valueOf(sc.id()), docSumDef);
            this.definitionsByName.put(sc.name(), docSumDef);
        }
        if (this.definitions.size() == 0) {
            log.warning("No summary classes found in DocumentdbInfoConfig.Documentdb");
        }
    }
}

