/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.container.search.LegacyEmulationConfig;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocsumDefinition {
    private String name;
    private final List<DocsumField> fields;
    private boolean dynamic = false;
    private final Map<String, Integer> fieldNameToIndex;

    DocsumDefinition(DocumentdbInfoConfig.Documentdb.Summaryclass config, LegacyEmulationConfig emulConfig) {
        this.name = config.name();
        ArrayList<DocsumField> fieldsBuilder = new ArrayList<DocsumField>();
        HashMap<String, Integer> fieldNameToIndexBuilder = new HashMap<String, Integer>();
        for (DocumentdbInfoConfig.Documentdb.Summaryclass.Fields field : config.fields()) {
            fieldNameToIndexBuilder.put(field.name(), fieldsBuilder.size());
            fieldsBuilder.add(DocsumField.create(field.name(), field.type(), emulConfig));
            if (!field.dynamic()) continue;
            this.dynamic = true;
        }
        this.fields = ImmutableList.copyOf(fieldsBuilder);
        this.fieldNameToIndex = ImmutableMap.copyOf(fieldNameToIndexBuilder);
    }

    public DocsumField getField(int fieldIndex) {
        if (fieldIndex >= this.fields.size()) {
            return null;
        }
        return this.fields.get(fieldIndex);
    }

    public Integer getFieldIndex(String fieldName) {
        return this.fieldNameToIndex.get(fieldName);
    }

    public String toString() {
        return "docsum definition '" + this.getName() + "'";
    }

    public String getName() {
        return this.name;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public List<DocsumField> getFields() {
        return this.fields;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }
}

