/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.LongstringField;
import com.yahoo.prelude.fastsearch.StringField;
import com.yahoo.prelude.fastsearch.VariableLengthField;
import com.yahoo.prelude.fastsearch.XMLField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Docsum {
    private final DocsumDefinition definition;
    private final byte[] packet;
    private final int[] fieldOffsets;
    private int largestStoredOffset = -1;

    public Docsum(DocsumDefinition definition, byte[] packet) {
        this.definition = definition;
        this.packet = packet;
        this.fieldOffsets = new int[definition.getFieldCount()];
    }

    public DocsumDefinition getDefinition() {
        return this.definition;
    }

    public Integer getFieldIndex(String fieldName) {
        return this.definition.getFieldIndex(fieldName);
    }

    public Object decode(int fieldIndex) {
        ByteBuffer b = this.packetAsBuffer();
        this.setAndReturnOffsetToField(b, fieldIndex);
        return this.definition.getField(fieldIndex).decode(b);
    }

    public FastHit.RawField fetchFieldAsUtf8(int fieldIndex) {
        DocsumField dataType = this.definition.getField(fieldIndex);
        if (!(dataType instanceof LongstringField || dataType instanceof XMLField || dataType instanceof StringField)) {
            return null;
        }
        ByteBuffer b = this.packetAsBuffer();
        DocsumField field = this.definition.getField(fieldIndex);
        int fieldStart = this.setAndReturnOffsetToField(b, fieldIndex);
        if (field.isCompressed(b)) {
            return null;
        }
        int length = field.getLength(b);
        if (field instanceof VariableLengthField) {
            int fieldLength = ((VariableLengthField)((Object)field)).sizeOfLength();
            b.position(fieldStart + fieldLength);
            length -= fieldLength;
        } else {
            b.position(fieldStart);
        }
        byte[] bufferView = new byte[length];
        b.get(bufferView);
        return new FastHit.RawField(dataType, bufferView);
    }

    public ByteBuffer packetAsBuffer() {
        ByteBuffer buffer = ByteBuffer.wrap(this.packet);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.getInt();
        return buffer;
    }

    private int setAndReturnOffsetToField(ByteBuffer b, int fieldIndex) {
        if (this.largestStoredOffset < 0) {
            this.fieldOffsets[0] = b.position();
            ++this.largestStoredOffset;
        }
        while (this.largestStoredOffset < fieldIndex) {
            int offsetOfLargest = this.fieldOffsets[this.largestStoredOffset];
            b.position(offsetOfLargest);
            this.fieldOffsets[this.largestStoredOffset + 1] = offsetOfLargest + this.definition.getField(this.largestStoredOffset).getLength(b);
            ++this.largestStoredOffset;
        }
        int offset = this.fieldOffsets[fieldIndex];
        b.position(offset);
        return offset;
    }

    public String toString() {
        return "docsum [definition: " + this.definition + "]";
    }
}

