/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.simple.Value;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.VariableLengthField;
import com.yahoo.prelude.hitfield.RawData;
import java.nio.ByteBuffer;

public class DataField
extends DocsumField
implements VariableLengthField {
    public DataField(String name) {
        super(name);
    }

    private Object convert(byte[] value) {
        return new RawData(value);
    }

    @Override
    public Object decode(ByteBuffer b) {
        int len = b.getShort() & 0xFFFF;
        byte[] tmp = new byte[len];
        b.get(tmp);
        return this.convert(tmp);
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    public String toString() {
        return "field " + this.getName() + " type data";
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int len = b.getShort() & 0xFFFF;
        b.position(offset + len + 2);
        return len + 2;
    }

    @Override
    public int sizeOfLength() {
        return 2;
    }

    @Override
    public Object convert(Inspector value) {
        return this.convert(value.asData(Value.empty().asData()));
    }
}

