/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryResultPacket;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.DocsumPacketKey;
import com.yahoo.prelude.fastsearch.PacketCache;
import com.yahoo.prelude.fastsearch.PacketWrapper;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;

public class CacheControl {
    private static final CompoundName nocachewrite = new CompoundName("nocachewrite");
    private final boolean activeCache;
    private final PacketCache packetCache;

    public CacheControl(int sizeMegaBytes, double cacheTimeOutSeconds) {
        this.activeCache = sizeMegaBytes > 0 && cacheTimeOutSeconds > 0.0;
        this.packetCache = this.activeCache ? new PacketCache(sizeMegaBytes, 0, cacheTimeOutSeconds) : null;
    }

    public final int capacity() {
        return this.packetCache.getCapacity();
    }

    public final boolean useCache(Query query) {
        return this.activeCache && !query.getNoCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PacketWrapper lookup(CacheKey key, Query query) {
        if (key != null && this.useCache(query)) {
            long now = System.currentTimeMillis();
            PacketCache packetCache = this.packetCache;
            synchronized (packetCache) {
                return this.packetCache.get(key, now);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCacheEntry(CacheKey key, Query query, QueryResultPacket resultPacket) {
        if (!this.activeCache) {
            return;
        }
        PacketWrapper wrapper = this.lookup(key, query);
        if (wrapper == null) {
            return;
        }
        long oldTimestamp = wrapper.getTimestamp();
        wrapper = (PacketWrapper)wrapper.clone();
        wrapper.addResultPacket(resultPacket);
        PacketCache packetCache = this.packetCache;
        synchronized (packetCache) {
            this.packetCache.put(key, wrapper, oldTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCacheEntry(CacheKey key, Query query, DocsumPacketKey[] packetKeys, Packet[] packets) {
        if (!this.activeCache) {
            return;
        }
        PacketWrapper wrapper = this.lookup(key, query);
        if (wrapper == null) {
            return;
        }
        wrapper = (PacketWrapper)wrapper.clone();
        wrapper.addDocsums(packetKeys, packets);
        PacketCache packetCache = this.packetCache;
        synchronized (packetCache) {
            this.packetCache.put(key, wrapper, wrapper.getTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cache(CacheKey key, Query query, DocsumPacketKey[] packetKeys, Packet[] packets) {
        if (!this.activeCache) {
            return;
        }
        if (query.getNoCache()) {
            return;
        }
        if (query.properties().getBoolean(nocachewrite)) {
            return;
        }
        PacketWrapper wrapper = this.lookup(key, query);
        if (wrapper == null) {
            wrapper = new PacketWrapper(key, packetKeys, packets);
            long now = System.currentTimeMillis();
            PacketCache packetCache = this.packetCache;
            synchronized (packetCache) {
                this.packetCache.put(key, wrapper, now);
            }
        }
        wrapper = (PacketWrapper)wrapper.clone();
        wrapper.addResultPacket((QueryResultPacket)packets[0]);
        wrapper.addDocsums(packetKeys, packets, 1);
        PacketCache packetCache = this.packetCache;
        synchronized (packetCache) {
            this.packetCache.put(key, wrapper, wrapper.getTimestamp());
        }
    }

    public void clear() {
        if (this.packetCache != null) {
            this.packetCache.clear();
        }
    }
}

