/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.fs4.PongPacket;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.statistics.ElapsedTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Pong {
    private String pingInfo = "";
    private final List<ErrorMessage> errors = new ArrayList<ErrorMessage>(1);
    private final Optional<PongPacket> pongPacket;
    private ElapsedTime elapsed = new ElapsedTime();

    public Pong() {
        this.pongPacket = Optional.empty();
    }

    public Pong(ErrorMessage error) {
        this.errors.add(error);
        this.pongPacket = Optional.empty();
    }

    public Pong(PongPacket pongPacket) {
        this.pongPacket = Optional.of(pongPacket);
    }

    public void addError(ErrorMessage error) {
        this.errors.add(error);
    }

    public ErrorMessage getError(int i) {
        return this.errors.get(i);
    }

    public int getErrorSize() {
        return this.errors.size();
    }

    @Deprecated
    public Optional<PongPacket> getPongPacket() {
        return this.pongPacket;
    }

    public Optional<Long> activeDocuments() {
        if (!this.pongPacket.isPresent()) {
            return Optional.empty();
        }
        return this.pongPacket.get().getActiveDocuments();
    }

    public Optional<Integer> activeNodes() {
        if (!this.pongPacket.isPresent()) {
            return Optional.empty();
        }
        return this.pongPacket.get().getActiveNodes();
    }

    public List<ErrorMessage> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean badResponse() {
        return !this.errors.isEmpty();
    }

    public void setPingInfo(String pingInfo) {
        if (pingInfo == null) {
            pingInfo = "";
        }
        this.pingInfo = pingInfo;
    }

    public String getPingInfo() {
        return this.pingInfo;
    }

    public ElapsedTime getElapsedTime() {
        return this.elapsed;
    }

    public String toString() {
        StringBuilder m = new StringBuilder("Result of pinging");
        if (this.pingInfo.length() > 0) {
            m.append(" using ");
            m.append(this.pingInfo);
        }
        if (this.errors.size() > 0) {
            m.append(" ");
        }
        for (int i = 0; i < this.errors.size(); ++i) {
            m.append(this.errors.get(i).toString());
            if (i >= this.errors.size() - 1) continue;
            m.append(", ");
        }
        return m.toString();
    }
}

