/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.google.common.collect.ImmutableList;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexModel;
import com.yahoo.prelude.SearchDefinition;
import com.yahoo.search.Query;
import com.yahoo.text.Lowercase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IndexFacts {
    private Map<String, List<String>> clusterByDocument;
    private Map<String, SearchDefinition> searchDefinitions = new LinkedHashMap<String, SearchDefinition>();
    private Map<String, List<String>> clusters = new LinkedHashMap<String, List<String>>();
    @Deprecated
    public static final String unionName = "unionOfAllKnown";
    private SearchDefinition unionSearchDefinition = new SearchDefinition("unionOfAllKnown");
    private boolean frozen;
    private boolean hasNGramIndices;

    public IndexFacts() {
    }

    public IndexFacts(IndexModel indexModel) {
        if (indexModel.getSearchDefinitions() != null && indexModel.getUnionSearchDefinition() != null) {
            this.setSearchDefinitions(indexModel.getSearchDefinitions(), indexModel.getUnionSearchDefinition());
        }
        if (indexModel.getMasterClusters() != null) {
            this.setMasterClusters(indexModel.getMasterClusters());
        }
    }

    private void setMasterClusters(Map<String, List<String>> clusters) {
        this.clusters = clusters;
        this.clusterByDocument = IndexFacts.invert(clusters);
    }

    private static Map<String, List<String>> invert(Map<String, List<String>> clusters) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : clusters.entrySet()) {
            for (String value : entry.getValue()) {
                IndexFacts.addEntry(result, value, entry.getKey());
            }
        }
        return result;
    }

    private static void addEntry(Map<String, List<String>> result, String key, String value) {
        List<String> values = result.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            result.put(key, values);
        }
        values.add(value);
    }

    public List<String> clustersHavingSearchDefinition(String searchDefinitionName) {
        if (this.clusterByDocument == null) {
            return Collections.emptyList();
        }
        List<String> clusters = this.clusterByDocument.get(searchDefinitionName);
        return clusters != null ? clusters : Collections.emptyList();
    }

    public void setClusters(Map<String, List<String>> clusters) {
        this.ensureNotFrozen();
        this.clusters = clusters;
        this.clusterByDocument = IndexFacts.invert(clusters);
    }

    @Deprecated
    public void setSearchDefinitions(Map<String, SearchDefinition> searchDefinitions, SearchDefinition unionSearchDefinition) {
        this.ensureNotFrozen();
        this.searchDefinitions = searchDefinitions;
        this.unionSearchDefinition = unionSearchDefinition;
    }

    private boolean isInitialized() {
        return this.searchDefinitions.size() > 0;
    }

    private boolean isIndexFromDocumentTypes(String indexName, List<String> documentTypes) {
        if (!this.isInitialized()) {
            return true;
        }
        if (documentTypes.isEmpty()) {
            return this.unionSearchDefinition.getIndex(indexName) != null;
        }
        DocumentTypeListOffset sd = this.chooseSearchDefinition(documentTypes, 0);
        while (sd != null) {
            Index index = sd.searchDefinition.getIndex(indexName);
            if (index != null) {
                return true;
            }
            sd = this.chooseSearchDefinition(documentTypes, sd.offset);
        }
        return false;
    }

    private String getCanonicNameFromDocumentTypes(String indexName, List<String> documentTypes) {
        if (!this.isInitialized()) {
            return indexName;
        }
        if (documentTypes.isEmpty()) {
            Index index = this.unionSearchDefinition.getIndexByLowerCase(Lowercase.toLowerCase((String)indexName));
            return index == null ? indexName : index.getName();
        }
        DocumentTypeListOffset sd = this.chooseSearchDefinition(documentTypes, 0);
        while (sd != null) {
            Index index = sd.searchDefinition.getIndexByLowerCase(Lowercase.toLowerCase((String)indexName));
            if (index != null) {
                return index.getName();
            }
            sd = this.chooseSearchDefinition(documentTypes, sd.offset);
        }
        return indexName;
    }

    private Index getIndexFromDocumentTypes(String indexName, List<String> documentTypes) {
        if (indexName == null || indexName.isEmpty()) {
            indexName = "default";
        }
        return this.getIndexByCanonicNameFromDocumentTypes(indexName, documentTypes);
    }

    private Index getIndexByCanonicNameFromDocumentTypes(String canonicName, List<String> documentTypes) {
        if (!this.isInitialized()) {
            return Index.nullIndex;
        }
        if (documentTypes.isEmpty()) {
            Index index = this.unionSearchDefinition.getIndex(canonicName);
            if (index == null) {
                return Index.nullIndex;
            }
            return index;
        }
        DocumentTypeListOffset sd = this.chooseSearchDefinition(documentTypes, 0);
        while (sd != null) {
            Index index = sd.searchDefinition.getIndex(canonicName);
            if (index != null) {
                return index;
            }
            sd = this.chooseSearchDefinition(documentTypes, sd.offset);
        }
        return Index.nullIndex;
    }

    private Set<String> resolveDocumentTypes(Query query) {
        return this.resolveDocumentTypes(query.getModel().getSources(), query.getModel().getRestrict(), this.searchDefinitions.keySet());
    }

    private Set<String> resolveDocumentTypes(Collection<String> sources, Collection<String> restrict, Set<String> candidateDocumentTypes) {
        sources = this.emptyCollectionIfNull(sources);
        restrict = this.emptyCollectionIfNull(restrict);
        if (sources.isEmpty()) {
            if (!restrict.isEmpty()) {
                return new TreeSet<String>(restrict);
            }
            return candidateDocumentTypes;
        }
        TreeSet<String> toSearch = new TreeSet<String>();
        for (String source : sources) {
            List<String> clusterDocTypes = this.clusters.get(source);
            if (clusterDocTypes == null) {
                if (!candidateDocumentTypes.contains(source)) continue;
                toSearch.add(source);
                continue;
            }
            for (String documentType : clusterDocTypes) {
                if (!candidateDocumentTypes.contains(documentType)) continue;
                toSearch.add(documentType);
            }
        }
        if (!restrict.isEmpty()) {
            toSearch.retainAll(restrict);
        }
        return toSearch;
    }

    private Collection<String> emptyCollectionIfNull(Collection<String> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    private DocumentTypeListOffset chooseSearchDefinition(List<String> documentTypes, int index) {
        while (index < documentTypes.size()) {
            String docName;
            SearchDefinition sd;
            if ((sd = this.searchDefinitions.get(docName = documentTypes.get(index++))) == null) continue;
            return new DocumentTypeListOffset(index, sd);
        }
        return null;
    }

    public void freeze() {
        this.hasNGramIndices = this.hasNGramIndices();
        this.frozen = true;
    }

    public boolean hasNGramIndices() {
        if (this.frozen) {
            return this.hasNGramIndices;
        }
        for (Map.Entry<String, SearchDefinition> searchDefinition : this.searchDefinitions.entrySet()) {
            for (Index index : searchDefinition.getValue().indices().values()) {
                if (!index.isNGram()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Tried to modify frozen IndexFacts instance.");
        }
    }

    @Deprecated
    public void addIndex(String sdName, String indexName) {
        SearchDefinition sd;
        this.ensureNotFrozen();
        if (sdName == null) {
            sd = this.unionSearchDefinition;
        } else if (this.searchDefinitions.containsKey(sdName)) {
            sd = this.searchDefinitions.get(sdName);
        } else {
            sd = new SearchDefinition(sdName);
            this.searchDefinitions.put(sdName, sd);
        }
        sd.getOrCreateIndex(indexName);
        this.unionSearchDefinition.getOrCreateIndex(indexName);
    }

    @Deprecated
    public void addIndex(String sdName, Index index) {
        SearchDefinition sd;
        this.ensureNotFrozen();
        if (sdName == null) {
            sd = this.unionSearchDefinition;
        } else if (this.searchDefinitions.containsKey(sdName)) {
            sd = this.searchDefinitions.get(sdName);
        } else {
            sd = new SearchDefinition(sdName);
            this.searchDefinitions.put(sdName, sd);
        }
        sd.addIndex(index);
        this.unionSearchDefinition.addIndex(index);
    }

    public String getDefaultPosition(String sdName) {
        SearchDefinition sd;
        if (sdName == null) {
            sd = this.unionSearchDefinition;
        } else if (this.searchDefinitions.containsKey(sdName)) {
            sd = this.searchDefinitions.get(sdName);
        } else {
            return null;
        }
        return sd.getDefaultPosition();
    }

    public Session newSession(Query query) {
        return new Session(query);
    }

    public Session newSession(Collection<String> sources, Collection<String> restrict) {
        return new Session((Collection)sources, (Collection)restrict);
    }

    public Session newSession(Collection<String> sources, Collection<String> restrict, Set<String> candidateDocumentTypes) {
        return new Session(sources, restrict, candidateDocumentTypes);
    }

    public class Session {
        private final List<String> documentTypes;

        private Session(Query query) {
            this.documentTypes = ImmutableList.copyOf((Collection)IndexFacts.this.resolveDocumentTypes(query));
        }

        private Session(Collection<String> sources, Collection<String> restrict) {
            this.documentTypes = ImmutableList.copyOf((Collection)IndexFacts.this.resolveDocumentTypes(sources, restrict, IndexFacts.this.searchDefinitions.keySet()));
        }

        private Session(Collection<String> sources, Collection<String> restrict, Set<String> candidateDocumentTypes) {
            this.documentTypes = ImmutableList.copyOf((Collection)IndexFacts.this.resolveDocumentTypes(sources, restrict, candidateDocumentTypes));
        }

        public Index getIndex(String indexName) {
            return IndexFacts.this.getIndexFromDocumentTypes(indexName, this.documentTypes);
        }

        public Index getIndex(String indexName, String documentType) {
            return IndexFacts.this.getIndexFromDocumentTypes(indexName, Collections.singletonList(documentType));
        }

        public String getCanonicName(String indexName) {
            return IndexFacts.this.getCanonicNameFromDocumentTypes(indexName, this.documentTypes);
        }

        public boolean isIndex(String indexName) {
            return IndexFacts.this.isIndexFromDocumentTypes(indexName, this.documentTypes);
        }

        public List<String> documentTypes() {
            return this.documentTypes;
        }

        public String toString() {
            return "index facts for search definitions " + this.documentTypes;
        }
    }

    private static class DocumentTypeListOffset {
        public final int offset;
        public final SearchDefinition searchDefinition;

        public DocumentTypeListOffset(int offset, SearchDefinition searchDefinition) {
            this.offset = offset;
            this.searchDefinition = searchDefinition;
        }
    }
}

