/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4.mplex;

import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.BufferTooSmallException;
import com.yahoo.fs4.PacketDecoder;
import com.yahoo.fs4.PacketListener;
import com.yahoo.fs4.mplex.Backend;
import com.yahoo.fs4.mplex.FS4Channel;
import com.yahoo.io.Connection;
import com.yahoo.io.Listener;
import com.yahoo.log.LogLevel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FS4Connection
implements Connection {
    private static Logger log = Logger.getLogger(FS4Connection.class.getName());
    private Backend backend;
    private Listener listener;
    private SocketChannel channel;
    private boolean shouldWrite = false;
    private static int idCounter = 1;
    private int idNumber;
    private int maxInitialSize = 1024;
    private ByteBuffer writeBuffer;
    private LinkedList<ByteBuffer> writeBufferList = new LinkedList();
    private ByteBuffer fixedReadBuffer;
    private ByteBuffer readBuffer = this.fixedReadBuffer = ByteBuffer.allocateDirect(262144);
    private volatile boolean valid = true;
    private final PacketListener packetListener;

    public FS4Connection(SocketChannel channel, Listener listener, Backend backend, PacketListener packetListener) {
        this.backend = backend;
        this.listener = listener;
        this.channel = channel;
        this.idNumber = idCounter++;
        this.packetListener = packetListener;
        log.log(Level.FINER, "new: " + this + ", id=" + this.idNumber + ", address=" + backend.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(BasicPacket packet, Integer channelId) throws IOException {
        ByteBuffer buffer = packet.grantEncodingBuffer(channelId, this.maxInitialSize);
        ByteBuffer viewForPacketListener = buffer.slice();
        FS4Connection fS4Connection = this;
        synchronized (fS4Connection) {
            if (!this.valid || !this.channel.isOpen()) {
                throw new IllegalStateException("Connection is not valid. Address = " + this.backend.getAddress() + ", valid = " + this.valid + ", isOpen = " + this.channel.isOpen());
            }
            if (buffer.capacity() > this.maxInitialSize) {
                this.maxInitialSize = buffer.limit();
            }
            if (this.writeBuffer == null) {
                this.writeBuffer = buffer;
            } else {
                this.writeBufferList.addLast(buffer);
                this.enableWrite();
            }
            this.write();
        }
        if (this.packetListener != null) {
            this.packetListener.packetSent(this.backend.getChannel(channelId), packet, viewForPacketListener);
        }
    }

    public synchronized void write() throws IOException {
        if (!this.channel.isOpen()) {
            throw new IllegalStateException("Channel not open in write(), address=" + this.backend.getAddress());
        }
        try {
            int bytesWritten = 0;
            boolean isFinished = false;
            do {
                if (this.writeBuffer == null) {
                    if (this.writeBufferList.isEmpty()) {
                        this.disableWrite();
                        isFinished = true;
                        break;
                    }
                    this.writeBuffer = this.writeBufferList.removeFirst();
                }
                bytesWritten = this.channel.write(this.writeBuffer);
                if (this.writeBuffer.hasRemaining()) continue;
                this.writeBuffer = null;
            } while (bytesWritten > 0);
            if (!isFinished) {
                this.enableWrite();
            }
        }
        catch (IOException e) {
            log.log((Level)LogLevel.DEBUG, "Failed writing to channel for backend " + this.backend.getAddress() + ". Closing channel", e);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private void disableWrite() {
        if (this.shouldWrite) {
            this.listener.modifyInterestOpsBatch((Connection)this, 4, false);
            this.shouldWrite = false;
        }
    }

    private void enableWrite() {
        if (!this.shouldWrite) {
            this.listener.modifyInterestOps((Connection)this, 4, true);
            this.shouldWrite = true;
        }
    }

    public void read() throws IOException {
        if (!this.channel.isOpen()) {
            throw new IOException("Channel not open in read(), address=" + this.backend.getAddress());
        }
        int bytesRead = 0;
        do {
            try {
                if (this.readBuffer == this.fixedReadBuffer) {
                    bytesRead = this.channel.read(this.readBuffer);
                } else {
                    this.fixedReadBuffer.clear();
                    if (this.readBuffer.remaining() < this.fixedReadBuffer.capacity()) {
                        this.fixedReadBuffer.limit(this.readBuffer.remaining());
                    }
                    bytesRead = this.channel.read(this.fixedReadBuffer);
                    this.fixedReadBuffer.flip();
                    this.readBuffer.put(this.fixedReadBuffer);
                    this.fixedReadBuffer.clear();
                }
            }
            catch (IOException e) {
                log.log(Level.FINER, "Read exception address=" + this.backend.getAddress() + " id=" + this.idNumber + ": " + e.getClass().getName() + " / ", e);
                bytesRead = -1;
            }
            if (bytesRead == -1) {
                log.log((Level)LogLevel.DEBUG, "Dispatch closed connection (id=" + this.idNumber + ", address=" + this.backend.getAddress() + ")");
                try {
                    this.close();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Close failed, address=" + this.backend.getAddress(), e);
                }
            }
            if (bytesRead != 0 || this.readBuffer.hasRemaining()) continue;
            log.fine("Buffer possibly too small, extending");
            this.readBuffer.flip();
            this.extendReadBuffer(this.readBuffer.capacity() * 2);
        } while (bytesRead > 0);
        this.readBuffer.flip();
        this.extractPackets(this.readBuffer);
    }

    private void extractPackets(ByteBuffer readBuffer) {
        while (true) {
            PacketDecoder.DecodedPacket packet = null;
            try {
                FS4Channel receiver = null;
                int queryId = PacketDecoder.sniffChannel(readBuffer);
                if (queryId == 0) {
                    if (PacketDecoder.isPongPacket(readBuffer)) {
                        receiver = this.backend.getPingChannel();
                    }
                } else {
                    receiver = this.backend.getChannel(new Integer(queryId));
                }
                if ((packet = PacketDecoder.extractPacket(readBuffer)) != null) {
                    this.packetListener.packetReceived(receiver, packet.packet, packet.consumedBytes);
                }
            }
            catch (BufferTooSmallException e) {
                log.fine("Unable to decode, extending readBuffer");
                this.extendReadBuffer(PacketDecoder.packetLength(readBuffer));
                return;
            }
            if (packet == null) {
                if (readBuffer.position() != 0 || readBuffer.limit() != readBuffer.capacity()) break;
                this.resetReadBuffer();
                break;
            }
            this.backend.receivePacket(packet.packet);
        }
    }

    public void close() throws IOException {
        this.valid = false;
        this.channel.close();
        log.log(Level.FINER, "invalidated id=" + this.idNumber + " address=" + this.backend.getAddress());
    }

    public void connect() throws IOException {
        throw new RuntimeException("connect() was called, address=" + this.backend.getAddress() + ".  asynchronous connect in NIO is flawed!");
    }

    public int selectOps() {
        return 1;
    }

    public SocketChannel socketChannel() {
        return this.channel;
    }

    public String toString() {
        return FS4Connection.class.getName() + "/" + this.channel;
    }

    private void extendReadBuffer(int size) {
        if (size == -1) {
            throw new RuntimeException("Invalid buffer size requested: -1");
        }
        if (size < this.readBuffer.capacity()) {
            size = this.readBuffer.capacity() * 2;
        }
        ByteBuffer tmp = ByteBuffer.allocate(size);
        tmp.put(this.readBuffer);
        log.fine("Extended readBuffer to " + size + " bytesfrom " + this.readBuffer.capacity() + " bytes");
        this.readBuffer = tmp;
    }

    private void resetReadBuffer() {
        this.fixedReadBuffer.clear();
        if (this.readBuffer == this.fixedReadBuffer) {
            return;
        }
        log.fine("Resetting readbuffer");
        this.readBuffer = this.fixedReadBuffer;
    }

    public boolean isValid() {
        return this.valid;
    }
}

