/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4.mplex;

import com.yahoo.fs4.mplex.FS4Connection;
import com.yahoo.log.LogLevel;
import java.util.Iterator;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class ConnectionPool {
    static final int CLEANINGPERIOD = 1000;
    private final Queue<FS4Connection> connections = new ConcurrentLinkedQueue<FS4Connection>();
    private final AtomicInteger activeConnections = new AtomicInteger(0);
    private final AtomicInteger passiveConnections = new AtomicInteger(0);
    private static final Logger log = Logger.getLogger(ConnectionPool.class.getName());

    public ConnectionPool() {
    }

    public ConnectionPool(Timer timer) {
        timer.schedule((TimerTask)new PoolCleanerTask(this), 1000L, 1000L);
    }

    private void dropInvalidConnections() {
        Iterator i = this.connections.iterator();
        while (i.hasNext()) {
            FS4Connection connection = (FS4Connection)i.next();
            if (connection.isValid()) continue;
            i.remove();
        }
    }

    private FS4Connection registerAsActiveIfNonZero(FS4Connection connection) {
        this.activeConnections.incrementAndGet();
        this.passiveConnections.decrementAndGet();
        return connection;
    }

    public FS4Connection getConnection() {
        return this.registerAsActiveIfNonZero(this.connections.poll());
    }

    void releaseConnection(FS4Connection connection) {
        assert (connection != null);
        this.activeConnections.decrementAndGet();
        if (connection.isValid()) {
            this.passiveConnections.incrementAndGet();
            this.connections.add(connection);
        }
    }

    void createdConnection() {
        this.activeConnections.incrementAndGet();
    }

    int activeConnections() {
        return this.activeConnections.get();
    }

    int passiveConnections() {
        return this.passiveConnections.get();
    }

    class PoolCleanerTask
    extends TimerTask {
        private final ConnectionPool connectionPool;

        public PoolCleanerTask(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
        }

        @Override
        public void run() {
            try {
                this.connectionPool.dropInvalidConnections();
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "Caught exception in connection pool cleaner, ignoring.", e);
            }
        }
    }
}

