/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4.mplex;

import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.PacketDumper;
import com.yahoo.fs4.PacketListener;
import com.yahoo.fs4.PacketNotificationsBroadcaster;
import com.yahoo.fs4.PacketQueryTracer;
import com.yahoo.fs4.mplex.ConnectionPool;
import com.yahoo.fs4.mplex.FS4Channel;
import com.yahoo.fs4.mplex.FS4Connection;
import com.yahoo.fs4.mplex.InvalidChannelException;
import com.yahoo.fs4.mplex.ListenerPool;
import com.yahoo.io.Connection;
import com.yahoo.io.ConnectionFactory;
import com.yahoo.io.Listener;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Backend
implements ConnectionFactory {
    private static final Logger log = Logger.getLogger(Backend.class.getName());
    private final ListenerPool listeners;
    private final InetSocketAddress address;
    private final String host;
    private final int port;
    private final Map<Integer, FS4Channel> activeChannels = new HashMap<Integer, FS4Channel>();
    private int channelId = 0;
    private boolean shutdownInitiated = false;
    private boolean areInSocketNotConnectableState = false;
    private final LinkedList<FS4Channel> pingChannels = new LinkedList();
    private final PacketListener packetListener;
    private final ConnectionPool connectionPool;
    private final PacketDumper packetDumper;
    private final AtomicInteger connectionCount = new AtomicInteger(0);

    protected Backend() {
        this.listeners = null;
        this.host = null;
        this.port = 0;
        this.packetListener = null;
        this.packetDumper = null;
        this.address = null;
        this.connectionPool = new ConnectionPool();
    }

    public Backend(String host, int port, String serverDiscriminator, ListenerPool listenerPool, ConnectionPool connectionPool) {
        String fileNamePattern = "qrs." + serverDiscriminator + '.' + host + ":" + port + ".%s.dump";
        this.packetDumper = new PacketDumper(new File(Defaults.getDefaults().underVespaHome("logs/vespa/qrs/")), fileNamePattern);
        this.packetListener = new PacketNotificationsBroadcaster(this.packetDumper, new PacketQueryTracer());
        this.listeners = listenerPool;
        this.host = host;
        this.port = port;
        this.address = new InetSocketAddress(host, port);
        this.connectionPool = connectionPool;
    }

    private void logWarning(String attemptDescription, Exception e) {
        log.log(Level.WARNING, "Exception on " + attemptDescription + " '" + this.host + ":" + this.port + "': " + Exceptions.toMessageString((Throwable)e));
    }

    private void logInfo(String attemptDescription, Exception e) {
        log.log(Level.INFO, "Exception on " + attemptDescription + " '" + this.host + ":" + this.port + "': " + Exceptions.toMessageString((Throwable)e));
    }

    private FS4Connection getConnection() throws IOException {
        FS4Connection connection = this.connectionPool.getConnection();
        if (connection == null) {
            connection = this.createConnection();
        }
        return connection;
    }

    public void returnConnection(FS4Connection connection) {
        this.connectionPool.releaseConnection(connection);
    }

    private FS4Connection createConnection() throws IOException {
        SocketChannel socket = SocketChannel.open();
        try {
            this.connectSocket(socket);
        }
        catch (Exception e) {
            if (!this.areInSocketNotConnectableState) {
                this.logInfo("connecting to", e);
            }
            this.areInSocketNotConnectableState = true;
            socket.close();
            return null;
        }
        this.areInSocketNotConnectableState = false;
        int listenerId = this.connectionCount.getAndIncrement() % this.listeners.size();
        Listener listener = this.listeners.get(listenerId);
        FS4Connection connection = new FS4Connection(socket, listener, this, this.packetListener);
        listener.registerConnection((Connection)connection);
        log.fine("Created new connection to " + this.host + ":" + this.port);
        this.connectionPool.createdConnection();
        return connection;
    }

    private void connectSocket(SocketChannel socket) throws IOException {
        socket.configureBlocking(false);
        boolean connected = socket.connect(this.address);
        if (!connected) {
            long timeBarrier = System.currentTimeMillis() + 20L;
            do {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Received InterruptedException while waiting for socket to connect.", e);
                }
            } while (!(connected = socket.finishConnect()) && System.currentTimeMillis() <= timeBarrier);
        }
        if (!connected) {
            throw new IllegalArgumentException("Could not create connection to dispatcher on " + this.address.getHostName() + ":" + this.address.getPort());
        }
        socket.socket().setTcpNoDelay(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FS4Channel openChannel() {
        int cachedChannelId;
        Backend backend = this;
        synchronized (backend) {
            if (this.channelId >= 0x7FFFFFFE) {
                this.channelId = 0;
            }
            cachedChannelId = this.channelId;
            this.channelId += 2;
        }
        Integer id = cachedChannelId;
        FS4Channel chan = new FS4Channel(this, id);
        Map<Integer, FS4Channel> map = this.activeChannels;
        synchronized (map) {
            this.activeChannels.put(id, chan);
        }
        return chan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FS4Channel openPingChannel() {
        FS4Channel chan = FS4Channel.createPingChannel(this);
        LinkedList<FS4Channel> linkedList = this.pingChannels;
        synchronized (linkedList) {
            this.pingChannels.add(chan);
        }
        return chan;
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FS4Channel getChannel(Integer id) {
        Map<Integer, FS4Channel> map = this.activeChannels;
        synchronized (map) {
            return this.activeChannels.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FS4Channel getPingChannel() {
        LinkedList<FS4Channel> linkedList = this.pingChannels;
        synchronized (linkedList) {
            return this.pingChannels.isEmpty() ? null : this.pingChannels.getFirst();
        }
    }

    public FS4Channel getChannel(int id) {
        return this.getChannel(new Integer(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FS4Channel removeChannel(Integer id) {
        Map<Integer, FS4Channel> map = this.activeChannels;
        synchronized (map) {
            return this.activeChannels.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FS4Channel removePingChannel() {
        LinkedList<FS4Channel> linkedList = this.pingChannels;
        synchronized (linkedList) {
            if (this.pingChannels.isEmpty()) {
                return null;
            }
            return this.pingChannels.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendPacket(BasicPacket packet, Integer channelId) throws IOException {
        if (this.shutdownInitiated) {
            log.fine("Tried to send packet after shutdown initiated.  Ignored.");
            return false;
        }
        FS4Connection connection = null;
        try {
            connection = this.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            connection.sendPacket(packet, channelId);
        }
        finally {
            if (connection != null) {
                this.returnConnection(connection);
            }
        }
        return true;
    }

    protected void receivePacket(BasicPacket packet) {
        FS4Channel fs4 = packet.hasChannelId() ? this.getChannel(((Packet)packet).getChannel()) : this.getPingChannel();
        if (fs4 == null) {
            return;
        }
        try {
            fs4.addPacket(packet);
        }
        catch (InterruptedException e) {
            log.info("Interrupted during packet adding. Packet = " + packet.toString());
            Thread.currentThread().interrupt();
        }
        catch (InvalidChannelException e) {
            log.log(Level.WARNING, "Channel was invalid. Packet = " + packet.toString() + " Backend probably sent data pertaining an old request, system may be overloaded.");
        }
    }

    public void shutdown() {
        log.fine("shutting down");
        if (this.shutdownInitiated) {
            throw new IllegalStateException("Shutdown already in progress");
        }
        this.shutdownInitiated = true;
    }

    public void close() {
        FS4Connection c = this.connectionPool.getConnection();
        while (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                this.logWarning("closing", e);
            }
            c = this.connectionPool.getConnection();
        }
    }

    public Connection newConnection(SocketChannel channel, Listener listener) {
        return new FS4Connection(channel, listener, this, this.packetListener);
    }

    public String toString() {
        return "Backend/" + this.host + ":" + this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendStatistics getStatistics() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return new BackendStatistics(this.connectionPool.activeConnections(), this.connectionPool.passiveConnections());
        }
    }

    public void dumpPackets(PacketDumper.PacketType packetType, boolean on) throws IOException {
        this.packetDumper.dumpPackets(packetType, on);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static final class BackendStatistics {
        public final int activeConnections;
        public final int passiveConnections;

        public BackendStatistics(int activeConnections, int passiveConnections) {
            this.activeConnections = activeConnections;
            this.passiveConnections = passiveConnections;
        }

        public String toString() {
            return this.activeConnections + "/" + this.totalConnections();
        }

        public int totalConnections() {
            return this.activeConnections + this.passiveConnections;
        }
    }
}

