/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.HexByteIterator;
import com.yahoo.fs4.PacketListener;
import com.yahoo.fs4.mplex.FS4Channel;
import com.yahoo.search.Query;
import java.nio.ByteBuffer;

public class PacketQueryTracer
implements PacketListener {
    private static final int traceLevel = 10;

    private void addTrace(FS4Channel channel, BasicPacket packet, ByteBuffer serializedForm) {
        Query query = channel.getQuery();
        if (query != null && query.getTraceLevel() >= 10) {
            StringBuilder traceString = new StringBuilder();
            traceString.append(packet.getClass().getSimpleName()).append(": ");
            this.hexDump(serializedForm, traceString);
            boolean includeQuery = true;
            query.trace(traceString.toString(), true, 10);
        }
    }

    private void hexDump(ByteBuffer serializedForm, StringBuilder traceString) {
        HexByteIterator hexByteIterator = new HexByteIterator(serializedForm);
        long count = 0L;
        int maxNumCharacters = 80;
        while (hexByteIterator.hasNext()) {
            if (++count % 80L == 0L) {
                traceString.append('\n');
            }
            traceString.append(hexByteIterator.next());
        }
    }

    @Override
    public void packetSent(FS4Channel channel, BasicPacket packet, ByteBuffer serializedForm) {
        this.addTrace(channel, packet, serializedForm);
    }

    @Override
    public void packetReceived(FS4Channel channel, BasicPacket packet, ByteBuffer serializedForm) {
        this.addTrace(channel, packet, serializedForm);
    }
}

