/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import java.nio.ByteBuffer;
import java.util.Iterator;

public final class HexByteIterator
implements Iterator<String> {
    private final ByteBuffer buffer;

    private String hexByte(byte b) {
        boolean singleChar;
        int unsignedValue = b & 0xFF;
        String s = Integer.toHexString(unsignedValue).toUpperCase();
        boolean bl = singleChar = unsignedValue < 16;
        if (singleChar) {
            return '0' + s;
        }
        return s;
    }

    @Override
    public boolean hasNext() {
        return this.buffer.hasRemaining();
    }

    @Override
    public String next() {
        return this.hexByte(this.buffer.get());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public HexByteIterator(ByteBuffer buffer) {
        this.buffer = buffer.slice();
    }
}

