/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.document.GlobalId;
import com.yahoo.fs4.QueryResultPacket;
import java.nio.ByteBuffer;

public class DocumentInfo
implements Cloneable {
    private final GlobalId globalId;
    private final double metric;
    private final int partId;
    private final int distributionKey;

    DocumentInfo(ByteBuffer buffer, QueryResultPacket owner) {
        byte[] rawGid = new byte[12];
        buffer.get(rawGid);
        this.globalId = new GlobalId(rawGid);
        this.metric = this.decodeMetric(buffer);
        this.partId = owner.getMldFeature() ? buffer.getInt() : 0;
        this.distributionKey = owner.getMldFeature() ? buffer.getInt() : 0;
    }

    public DocumentInfo(GlobalId globalId, int metric, int partId, int distributionKey) {
        this.globalId = globalId;
        this.metric = metric;
        this.partId = partId;
        this.distributionKey = distributionKey;
    }

    private double decodeMetric(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public GlobalId getGlobalId() {
        return this.globalId;
    }

    public double getMetric() {
        return this.metric;
    }

    public int getPartId() {
        return this.partId;
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    public String toString() {
        return "document info [globalId=" + this.globalId + ", metric=" + this.metric + "]";
    }

    public Object clone() {
        try {
            DocumentInfo docInfo = (DocumentInfo)super.clone();
            return docInfo;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Someone inserted a nonclonable superclass");
        }
    }
}

