/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import java.util.logging.Logger;

public enum OrtLoggingLevel {
    ORT_LOGGING_LEVEL_VERBOSE(0),
    ORT_LOGGING_LEVEL_INFO(1),
    ORT_LOGGING_LEVEL_WARNING(2),
    ORT_LOGGING_LEVEL_ERROR(3),
    ORT_LOGGING_LEVEL_FATAL(4);

    private final int value;
    private static final Logger logger;
    private static final OrtLoggingLevel[] values;

    private OrtLoggingLevel(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static OrtLoggingLevel mapFromInt(int logLevel) {
        if (logLevel > 0 && logLevel < values.length) {
            return values[logLevel];
        }
        logger.warning("Unknown logging level " + logLevel + " setting to ORT_LOGGING_LEVEL_VERBOSE");
        return ORT_LOGGING_LEVEL_VERBOSE;
    }

    static {
        logger = Logger.getLogger(OrtLoggingLevel.class.getName());
        values = new OrtLoggingLevel[5];
        OrtLoggingLevel[] ortLoggingLevelArray = OrtLoggingLevel.values();
        int n = ortLoggingLevelArray.length;
        for (int i = 0; i < n; ++i) {
            OrtLoggingLevel ot;
            OrtLoggingLevel.values[ot.value] = ot = ortLoggingLevelArray[i];
        }
    }
}

