/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.shared;

import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.IntermediateSession;
import com.yahoo.messagebus.IntermediateSessionParams;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.shared.ClientSession;
import com.yahoo.messagebus.shared.ServerSession;
import com.yahoo.messagebus.shared.SharedMessageBus;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedIntermediateSession
extends AbstractResource
implements ClientSession,
ServerSession,
MessageHandler,
ReplyHandler {
    private static final Logger log = Logger.getLogger(SharedIntermediateSession.class.getName());
    private final AtomicReference<MessageHandler> msgHandler = new AtomicReference();
    private final IntermediateSession session;
    private final ResourceReference mbusReference;

    public SharedIntermediateSession(SharedMessageBus mbus, IntermediateSessionParams params) {
        if (params.getReplyHandler() != null) {
            throw new IllegalArgumentException("Reply handler must be null.");
        }
        this.msgHandler.set(params.getMessageHandler());
        this.session = mbus.messageBus().createDetachedIntermediateSession(params.setReplyHandler((ReplyHandler)this).setMessageHandler((MessageHandler)this));
        this.mbusReference = mbus.refer();
    }

    public IntermediateSession session() {
        return this.session;
    }

    @Override
    public Result sendMessage(Message msg) {
        this.session.forward((Routable)msg);
        return Result.ACCEPTED;
    }

    @Override
    public void sendReply(Reply reply) {
        this.session.forward((Routable)reply);
    }

    @Override
    public MessageHandler getMessageHandler() {
        return this.msgHandler.get();
    }

    @Override
    public void setMessageHandler(MessageHandler msgHandler) {
        if (!this.msgHandler.compareAndSet(null, msgHandler)) {
            throw new IllegalStateException("Message handler already registered.");
        }
    }

    public void handleMessage(Message msg) {
        MessageHandler msgHandler = this.msgHandler.get();
        if (msgHandler == null) {
            EmptyReply reply = new EmptyReply();
            reply.swapState((Routable)msg);
            reply.addError(new Error(100005, "Session not fully configured yet."));
            this.sendReply((Reply)reply);
            return;
        }
        msgHandler.handleMessage(msg);
    }

    public void handleReply(Reply reply) {
        reply.popHandler().handleReply(reply);
    }

    @Override
    public String connectionSpec() {
        return this.session.getConnectionSpec();
    }

    @Override
    public String name() {
        return this.session.getName();
    }

    public void connect() {
        this.session.connect();
    }

    protected void destroy() {
        log.log(Level.FINE, "Destroying shared intermediate session.");
        this.session.destroy();
        this.mbusReference.close();
    }
}

